// =====================================================================
//  $Id: isocket.cc,v 1.2 2003/07/30 16:21:39 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: isocket.cc,v $
//  Revision 1.2  2003/07/30 16:21:39  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TInputObjectSocket.hh"
#include "TBenchmark.hh"

int main( int argc, char** argv, char** envv )
{
  enum { exCommand, exPort, exNumberOfArguments };
  if ( argc != exNumberOfArguments ) {
    Tcerr << "usage: " << argv[ exCommand ] << Tspace << "<port>" << Tendl;
    return( -1 );
  }
  const Tint port = atoi( argv[ exPort ] );
  TInputObjectSocket isocket( port );
  Tint nevents = 0;
  Tint datasize = 0;

  TDataRecord record;
  TBenchmark bench;
  bench.Start();
  while ( ( isocket >> record ) != 0 ) {
    Tcout << record << Tendl;
    datasize += record.GetRecordSize();
    nevents ++;
  }
  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << isocket.GetTotalDataSize();
  Tcout << " byte data has been received." << Tendl;

  return( 0 );
}
