// =====================================================================
//  $Id: omemory.cc,v 1.2 2003/07/30 16:21:39 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: omemory.cc,v $
//  Revision 1.2  2003/07/30 16:21:39  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TOutputObjectSharedMemory.hh"
#include "TBenchmark.hh"

#include "testrecord.h"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<nevent>" << Tendl;
    return( -1 );
  }
  const Tint nevent = atoi( argv[ 1 ] );
  TOutputObjectSharedMemory omemory;
  Tint datasize = 0;
  Tint nevents = 0;

  TBenchmark bench;
  bench.Start();
  for ( Tint i = 0; i < nevent; i ++ ) {
    TDataRecord record = testrecord( i );
    omemory << record;
    datasize += record.GetRecordSize();
    nevents ++;
  }
  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << omemory.GetTotalDataSize();
  Tcout << " byte data has been written." << Tendl;

  return( 0 );
}
