// =====================================================================
//  $Id: TAnalysisStatus.hh,v 1.2 2003/07/30 16:17:10 goiwai Exp $
//  $Name: CLDAQ-1-08-01 $
//
//  $Log: TAnalysisStatus.hh,v $
//  Revision 1.2  2003/07/30 16:17:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TANALYSISSTATUS_HH
#define __TANALYSISSTATUS_HH

#include "Tglobals.h"

class TAnalysisStatus
{

  private:
    Tstring theID;
    Tobject_t theObjectType;
    Tstring theDrawableObjectID;
    Tstring theCanvasID;
    Tstatus_t theStatus;
    Tthread_t theThreadID;

  public:
    TAnalysisStatus( const Tstring& id = "", Tobject_t type = tObjectUnknown, const Tstring& objectid = "", const Tstring& canvasid = "", Tstatus_t status = tStatusUnknown );
    TAnalysisStatus( const TAnalysisStatus& right );
    ~TAnalysisStatus();

  public:
    const TAnalysisStatus& operator=( const TAnalysisStatus& right );
    Tbool operator==( const TAnalysisStatus& right ) const;
    Tbool operator!=( const TAnalysisStatus& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TAnalysisStatus& right );

  public:
    Tstatus_t GetStatus() const;
    Tobject_t GetObjectType() const;
    const Tstring& GetID() const;
    const Tstring& GetDrawableObjectID() const;
    const Tstring& GetCanvasID() const;
    Tstring& GetID();
    Tstring& GetDrawableObjectID();
    Tstring& GetCanvasID();
    Tvoid SetStatus( Tstatus_t status );
    Tvoid SetObjectType( Tobject_t type );
    Tvoid SetID( const Tstring& id );
    Tvoid SetDrawableObjectID( const Tstring& id );
    Tvoid SetCanvasID( const Tstring& id );
    Tthread_t* GetThreadID();
    Tvoid SetThreadID( Tthread_t thread );

};

inline Tstatus_t TAnalysisStatus::GetStatus() const
{
  return( theStatus );
}

inline Tobject_t TAnalysisStatus::GetObjectType() const
{
  return( theObjectType );
}

inline const Tstring& TAnalysisStatus::GetID() const
{
  return( theID );
}

inline const Tstring& TAnalysisStatus::GetDrawableObjectID() const
{
  return( theDrawableObjectID );
}

inline const Tstring& TAnalysisStatus::GetCanvasID() const
{
  return( theCanvasID );
}

inline Tstring& TAnalysisStatus::GetID()
{
  return( theID );
}

inline Tstring& TAnalysisStatus::GetDrawableObjectID()
{
  return( theDrawableObjectID );
}

inline Tstring& TAnalysisStatus::GetCanvasID()
{
  return( theCanvasID );
}

inline Tvoid TAnalysisStatus::SetStatus( Tstatus_t status )
{
  theStatus = status;
  return;
}

inline Tvoid TAnalysisStatus::SetID( const Tstring& id )
{
  theID = id;
  return;
}

inline Tvoid TAnalysisStatus::SetDrawableObjectID( const Tstring& id )
{
  theDrawableObjectID = id;
  return;
}

inline Tvoid TAnalysisStatus::SetCanvasID( const Tstring& id )
{
  theCanvasID = id;
  return;
}

inline Tthread_t* TAnalysisStatus::GetThreadID()
{
  return( &theThreadID );
}

inline Tvoid TAnalysisStatus::SetThreadID( Tthread_t thread )
{
  theThreadID = thread;
  return;
}

#endif
