// =====================================================================
//  $Id: TCrate.hh,v 1.2 2003/07/30 16:19:10 goiwai Exp $
//  $Name: CLDAQ-1-08-01 $
//
//  $Log: TCrate.hh,v $
//  Revision 1.2  2003/07/30 16:19:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TCRATE_HH
#define __TCRATE_HH

#include "Tglobals.h"
#include "TModuleTable.hh"

class TModule;

class TCrate
{

  private:
    TModuleTable theModuleTable;

  public:
    TCrate();
    ~TCrate();

  public:
    Tint InstallModule( TModule* module, const Tstring& id, const TstringList& group );
    Tint InstallModule( TModule* module, const Tstring& id, const Tstring& group = "" );
    Tint RemoveModule( Tint index );
    Tint RemoveModule( const Tstring& id );
    Tint RemoveModule( const TstringList& groups );
    Tvoid ClearCrate();
    TModule* FindModule( const Tstring& id );
    TModule* GetModule( Tint index );
    TModule* GetModule( const Tstring& id );

  public:
    const TModuleTable& GetModuleTable() const;
    TModuleTable& GetModuleTable();
    Tvoid SetModuleTable( const TModuleTable& table );

  public:
    Tvoid Clear();
    Tvoid Clear( const TstringList& groups );
    Tvoid Clear( const Tstring& group );
    Tvoid Update();
    Tvoid Update( const TstringList& groups );
    Tvoid Update( const Tstring& group );
    Tvoid Initialize();
    Tvoid Initialize( const TstringList& groups );
    Tvoid Initialize( const Tstring& group );
    Tvoid ClearAllModules();
    Tvoid UpdateAllModules();
    Tvoid InitializeAllModules();
    Tvoid ClearModule( const Tstring& id );
    Tvoid UpdateModule( const Tstring& id );
    Tvoid InitializeModule( const Tstring& id );

};

inline const TModuleTable& TCrate::GetModuleTable() const
{
  return( theModuleTable );
}

inline TModuleTable& TCrate::GetModuleTable()
{
  return( theModuleTable );
}

inline Tvoid TCrate::SetModuleTable( const TModuleTable& table )
{
  theModuleTable = table;
  return;
}

#endif
