// =====================================================================
//  $Id: TOutputObjectStream.hh,v 1.2 2003/07/30 16:19:31 goiwai Exp $
//  $Name: CLDAQ-1-08-01 $
//
//  $Log: TOutputObjectStream.hh,v $
//  Revision 1.2  2003/07/30 16:19:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TOUTPUTOBJECTSTREAM_HH
#define __TOUTPUTOBJECTSTREAM_HH

#include "Tglobals.h"
#include "TObjectStream.hh"

class TStreamableObject;
class TObjectFilter;

class TOutputObjectStream
  : public TObjectStream
{

  public:
    TOutputObjectStream( Tstream_t streamtype = tUnknownStream );
    TOutputObjectStream( TObjectFilter* filter, Tstream_t streamtype = tUnknownStream );

  protected:
    virtual ~TOutputObjectStream();

  public:
    virtual Tint Write( TStreamableObject& object ) = 0;
    friend Tint operator<<( TOutputObjectStream& left, TStreamableObject& object );
    friend Tint operator<<( TOutputObjectStream& left, const TStreamableObject& object );

};

inline Tint operator<<( TOutputObjectStream& left, TStreamableObject& object )
{
  return( left.Write( object ) );
}

inline Tint operator<<( TOutputObjectStream& left, const TStreamableObject& object )
{
  return( left.Write( *(TStreamableObject*)(&object) ) );
}

#endif
