// =====================================================================
//  $Id: TReadoutSegment.cc,v 1.3 2003/07/30 16:20:11 goiwai Exp $
//  $Name: CLDAQ-1-08-01 $
//
//  $Log: TReadoutSegment.cc,v $
//  Revision 1.3  2003/07/30 16:20:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TReadoutSegment.hh"
#include "TDataSegment.hh"
#include "TModule.hh"

TReadoutSegment::TReadoutSegment(  const Tstring& id )
  : TReadoutIdentification( id ), TReadoutElementList(), theModule( 0 )
{;}

TReadoutSegment::TReadoutSegment( TModule* module, const Tstring& id )
  : TReadoutIdentification( id ), TReadoutElementList(), theModule( module )
{
  for ( Tint i = 0; i < module -> GetNumberOfChannels(); i ++ ) {
    push_back( TReadoutElement( theModule, itostr( i, 1 ), i ) );
  }
}

TReadoutSegment::TReadoutSegment( TModule* module, Tint ch, const Tstring& id )
  : TReadoutIdentification( id ), TReadoutElementList(), theModule( module )
{
  push_back( TReadoutElement( theModule, itostr( ch, 1 ), ch ) );
}

TReadoutSegment::TReadoutSegment( TModule* module, const TstringList& elementid, const Tstring& id )
  : TReadoutIdentification( id ), TReadoutElementList(), theModule( module )
{
  Tsize_t nch = (Tsize_t)( theModule -> GetNumberOfChannels() );
  if ( nch > elementid.size() ) {
    for ( Tsize_t i = elementid.size(); i < nch; i ++ ) {
      ( (TstringList*)(&elementid) ) -> push_back( itostr( i, 1 ) );
    }
  }

  for ( Tsize_t i = 0; i < nch; i ++ ) {
    push_back( TReadoutElement( theModule, elementid[ i ], i ) );
  }
}

TReadoutSegment::TReadoutSegment( TModule* module, const Tstring elementid[], const Tstring& id )
  : TReadoutIdentification( id ), TReadoutElementList(), theModule( module )
{
  Tint nch = module -> GetNumberOfChannels();
  // dangerous, no check, should be check string array here.
  for ( Tint i = 0; i < nch; i ++ ) {
    push_back( TReadoutElement( module, elementid[ i ], i ) );
  }
}

TReadoutSegment::TReadoutSegment( const TReadoutSegment& right )
  : TReadoutIdentification( right ), TReadoutElementList( right ),
    theModule( right.theModule )
{;}

TReadoutSegment::~TReadoutSegment()
{;}

TDataSegment TReadoutSegment::Read()
{
  TDataSegment segment( theID );
  for ( Tsize_t i = 0; i < size(); i ++ ) {
    segment.push_back( ( (*this)[ i ] ).Read() );
  }
  return( segment );
}

const TReadoutSegment& TReadoutSegment::operator=( const TReadoutSegment& right )
{
  *( (TReadoutIdentification*)this ) = *( (TReadoutIdentification*)(&right) );
  *( (TReadoutElementList*)this ) = *( (TReadoutElementList*)(&right) );
  *theModule = *(right.theModule);
  return( *this );
}

Tbool TReadoutSegment::operator==( const TReadoutSegment& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TReadoutIdentification*)this ) == *( (TReadoutIdentification*)(&right) ) );
  ret &= ( *( (TReadoutElementList*)this ) == *( (TReadoutElementList*)(&right) ) );
  ret &= ( *theModule == *(right.theModule) );
  return( ret );
}

Tbool TReadoutSegment::operator!=( const TReadoutSegment& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TReadoutIdentification*)this ) != *( (TReadoutIdentification*)(&right) ) );
  ret |= ( *( (TReadoutElementList*)this ) != *( (TReadoutElementList*)(&right) ) );
  ret |= ( *theModule != *(right.theModule) );
  return( ret );
}
