// =====================================================================
//  $Id: findelement.cc,v 1.2 2003/07/30 16:21:38 goiwai Exp $
//  $Name: CLDAQ-1-08-01 $
//
//  $Log: findelement.cc,v $
//  Revision 1.2  2003/07/30 16:21:38  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"
#include "TBenchmark.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }

  const Tstring filename = argv[ 1 ];
  Tstring sectag;
  Tstring segtag;
  Tstring eletag;
  if ( filename == "ofile.drec" ) {
    sectag = "This is Data Section.";
    segtag = "This is a Data Segement identified 0.";
    eletag = "This is unsigned short data array.";
  } else if ( filename == "software.drec" ) {
    sectag = "This section is for software modules.";
    segtag = "ADC";
    eletag = "channel 5";
  } else {
    Tcerr << argv[ 0 ] << ": unkown tags." << Tendl;
    return( -1 );
  }

  Tstring findtag[ 3 ] = { sectag, segtag, eletag };

  TInputObjectFile ifile( filename );

  TDataRecord record;
  TDataElement element;
  TBenchmark bench;
  bench.Start();
  Tint nelements = 0;
  while ( ( ifile >> record ) != 0 ) {
    if ( record.FindDataElement( findtag, element ) ) {
      Tcout << "Find element tagged \"" << element.GetID() << "\"." << Tendl;
      nelements ++;
    }
  }
  Tcout << nelements << " element(s) have been found out from ";
  Tcout << filename << "." << Tendl;
  bench.Stop();
  Tcout << bench << Tendl;

  return( 0 );
}
