// =====================================================================
//  $Id: Bt00RunAction.cc,v 1.3 2003/07/30 16:13:49 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: Bt00RunAction.cc,v $
//  Revision 1.3  2003/07/30 16:13:49  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TOutputObjectFile.hh"
#include "TRun.hh"
#include "TReadoutList.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TReadoutBook.hh"
#include "TCrate.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TSoftwareScalerModule.hh"

#include "Bt00RunAction.hh"
#include "Bt00RunSummary.hh"

Bt00RunAction::Bt00RunAction()
  : theOutputFile( 0 ), theRunSummary( 0 ), theOutputHtml()
{;}

Bt00RunAction::~Bt00RunAction()
{;}

Tvoid Bt00RunAction::BeginOfRunAction( TRun& aRun )
{
  static const Tstring drecext = ".drec";
  static const Tstring htmlext = ".html";

  Tint runid = aRun.GetRunID();
  Tstring filename = "run";
  Tstring runidstr = aRun.GetStringRunID();

  Tstring drecfile = filename + runidstr + drecext;
  Tstring htmlfile = filename + runidstr + htmlext;

  theOutputFile = new TOutputObjectFile( drecfile );
  Tcout << "event data outputs into " << drecfile << Tendl;

  theCrate -> Initialize( "run begin" );
  TSoftwareScalerModule* runnumber = (TSoftwareScalerModule*)( theCrate -> GetModule( "Run ID" ) );
  runnumber -> SetData( 0, runid );

  TDataRecord record =
    theReadoutBook -> GetReadoutList( "RUN BEGIN" ) -> Read();
  *theOutputFile << record;

  theOutputHtml.Open( htmlfile );
  theRunSummary = new Bt00RunSummary();
  fillRunBeginInformation( record );

  return;
}

Tvoid Bt00RunAction::EndOfRunAction( TRun& aRun )
{
  TDataRecord record =
    theReadoutBook -> GetReadoutList( "RUN END" ) -> Read();
  *theOutputFile << record;

  fillRunEndInformation( record );
  Tstring title = "Run Summary #" + (theRunManager->GetRun()).GetStringRunID();
  theOutputHtml.SetTitle( title );
  theOutputHtml << theRunSummary -> GenerateRunSummaryTable() << Tendl;
  theOutputHtml.Close();


  delete theRunSummary;
  delete theOutputFile;
  theRunSummary = 0;
  theOutputFile = 0;

  return;
}

Tvoid Bt00RunAction::fillRunBeginInformation( const TDataRecord& record )
{
  static Tstring runidset[ 3 ] = { "INFO", "Run ID", "0" };
  static Tstring clockset[ 3 ] = { "INFO", "Clock", "0" };

  TDataElement runid;
  TDataElement clock;
  record.FindDataElement( runidset, runid );
  record.FindDataElement( clockset, clock );

  theRunSummary -> SetRecordName( theOutputFile -> GetFileName() );
  theRunSummary -> SetRunID( *( runid.GetIntData() ) );
  theRunSummary -> SetRunBeginTime( *( clock.GetStringData() ) );

  return;
}

Tvoid Bt00RunAction::fillRunEndInformation( const TDataRecord& record )
{
  static Tstring clockset[ 3 ] = { "INFO", "Clock", "0" };
  TDataElement clock;
  record.FindDataElement( clockset, clock );

  TRunInformationTable table = theRunManager -> GetRunInformationModule() -> GetRunInformationTable();
  theRunSummary -> SetRunInformationTable( table );
  theRunSummary -> SetRunEndTime( *( clock.GetStringData() ) );
  theRunSummary -> SetRecordSize( theOutputFile -> GetTotalDataSize() );

  return;
}
