// =====================================================================
//  $Id: Rs00EventAction.cc,v 1.2 2003/07/30 16:14:23 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: Rs00EventAction.cc,v $
//  Revision 1.2  2003/07/30 16:14:23  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TEvent.hh"
#include "TRunManager.hh"
#include "TOutputObjectFile.hh"
#include "TSoftwareInterruptRegisterModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TCrate.hh"
#include "TReadoutBook.hh"
#include "TEnvironmentVariableTable.hh"

#include "Rs00EventAction.hh"
#include "Rs00RunAction.hh"

Rs00EventAction::Rs00EventAction()
{;}

Rs00EventAction::~Rs00EventAction()
{;}

TReadoutList* Rs00EventAction::WaitEvent()
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint rate = envtable.GetIntegerValue( "RS00_KEITHLEY_SAMPLING_RATE" );
  sleep( rate );
  return( theReadoutBook -> GetReadoutList( "EVENT" ) );
}

Tvoid Rs00EventAction::EndOfEventAction( TEvent& anEvent )
{
  Rs00RunAction* action =
    (Rs00RunAction*)( theRunManager -> GetRunAction() );
  TOutputObjectFile* ofile = action -> GetOutputFile();
  ofile -> Write( anEvent.GetDataRecord() );
  theCrate -> Update();
  return;
}
