// =====================================================================
//  $Id: Sw00CrateDefinition.cc,v 1.2 2003/07/30 16:15:15 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: Sw00CrateDefinition.cc,v $
//  Revision 1.2  2003/07/30 16:15:15  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TCrate.hh"
#include "TRunManager.hh"
#include "Sw00CrateDefinition.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareTimerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TSoftwareFlashAdcModule.hh"
#include "TSoftwareAdcModule.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TSoftwareInterruptRegisterModule.hh"
#include "TSoftwareDataFileModule.hh"
#include "TRunInformationTable.hh"
#include "TRunInformationList.hh"
#include "TRunInformation.hh"
#include "TEnvironmentVariableTable.hh"

Sw00CrateDefinition::Sw00CrateDefinition()
  : TCrateDefinition()
{;}

Sw00CrateDefinition::~Sw00CrateDefinition()
{;}

TCrate* Sw00CrateDefinition::Define()
{
  const TEnvironmentVariableTable& envtable = 
    TRunManager::GetRunManager() -> GetEnvironmentVariableTable();
  Tint freq = envtable.GetIntegerValue( "SW00_INTERRUPT_FREQUENCY" );



  TRunInformationList infolist;
  infolist.push_back( TRunInformation( "OPERATOR", tInfoFreeValue ) );
  TstringList selectlist;
  selectlist.push_back( "REAL RUN" );
  selectlist.push_back( "SOFTWARE RUN" );
  selectlist.push_back( "SIMULATION RUN" );
  selectlist.push_back( "TEST RUN" );
  selectlist.push_back( "DUMMY RUN" );
  infolist.push_back( TRunInformation( "RUN TYPE", selectlist ) );
  selectlist.clear();
  selectlist.push_back( "1.0 MeV" );
  selectlist.push_back( "10.0 MeV" );
  selectlist.push_back( "100.0 MeV" );
  selectlist.push_back( "1.0 GeV" );
  selectlist.push_back( "10.0 MeV" );
  selectlist.push_back( "100.0 MeV" );
  infolist.push_back( TRunInformation( "BEAM ENERGY", selectlist ) );
  infolist.push_back( TRunInformation( "COMMENT", tInfoFreeText ) );
  TRunInformationTable table( infolist );


  TCrate* crate = new TCrate();

  crate -> InstallModule( new TSoftwareScalerModule( 1 ), "Run ID", "run begin initialize" );
  crate -> InstallModule( new TSoftwareScalerModule( 1 ), "Event ID", "run begin initialize" );


  TSoftwareRunInformationModule* runinfo = new TSoftwareRunInformationModule( table );
  crate -> InstallModule( runinfo, "Run Information" );
  TRunManager::GetRunManager() -> SetRunInformationModule( runinfo );

  crate -> InstallModule( new TSoftwareClockModule( 1 ), "Clock", "run begin initialize" );
  crate -> InstallModule( new TSoftwareTimerModule( Tusec, 1 ), "Timer", "run begin initialize" );
  crate -> InstallModule( new TSoftwareFlashAdcModule(), "Flash ADC", "run begin initialize" );
  crate -> InstallModule( new TSoftwareAdcModule(), "ADC", "run begin initialize" );
  crate -> InstallModule( new TSoftwareInterruptRegisterModule( 1, freq ), "Interrupt Register", "run begin initialize" );
  crate -> InstallModule( new TSoftwareDataFileModule( "sw00.g4dat", 2 ), "Geant4", "run begin initialize" );

  return( crate );
}
