// =====================================================================
//  $Id: Sw00RunSummary.cc,v 1.2 2003/07/30 16:15:16 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: Sw00RunSummary.cc,v $
//  Revision 1.2  2003/07/30 16:15:16  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunInformationList.hh"
#include "TRunInformation.hh"
#include "Sw00RunSummary.hh"

Sw00RunSummary::Sw00RunSummary()
  : theRunID( 0 ), 
    theRecordName(), 
    theRecordSize( 0 ), 
    theNumberOfEvents( 0 ),
    theRunInformationTable(),
    theRunBeginTime(),
    theRunEndTime()
{;}

Sw00RunSummary::~Sw00RunSummary()
{;}

Tvoid Sw00RunSummary::Initialize()
{
  theRunID = 0;
  theRecordName.erase();
  theRecordSize = 0;
  theNumberOfEvents = 0;
  theRunInformationTable.Clear();
  theRunBeginTime.erase();
  theRunEndTime.erase();
  return;
}

TRunInformationTable Sw00RunSummary::GenerateRunSummaryTable() const
{
  TRunInformationList infolist;
  infolist.push_back( TRunInformation( "Run ID", itostr( theRunID ) ) );
  infolist.push_back( TRunInformation( "Identification of object file", theRecordName ) );
  infolist.push_back( TRunInformation( "Size of object file", itostr( theRecordSize ) ) );
  infolist.push_back( TRunInformation( "Run Start", theRunBeginTime ) );
  infolist.push_back( TRunInformation( "Run Stop", theRunEndTime ) );
  infolist.push_back( TRunInformation( "Number of events", itostr( theNumberOfEvents ) ) );

  return( theRunInformationTable + infolist );
}
