// =====================================================================
//  $Id: St00RunAction.cc,v 1.3 2003/07/30 16:15:52 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: St00RunAction.cc,v $
//  Revision 1.3  2003/07/30 16:15:52  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TOutputObjectFile.hh"
#include "TRun.hh"
#include "TReadoutList.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TReadoutBook.hh"
#include "TCrate.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TEnvironmentVariableTable.hh"
#include "TVmeRpv130Module.hh"

#include "St00RunAction.hh"
#include "St00RunSummary.hh"

St00RunAction::St00RunAction()
  : theOutputFile( 0 ), theRunSummary( 0 ), theOutputHtml()
{;}

St00RunAction::~St00RunAction()
{;}

Tvoid St00RunAction::BeginOfRunAction( TRun& aRun )
{
  Tstring drecfile;
  Tstring htmlfile;
  setFileName( aRun.GetRunID(), drecfile, htmlfile );

  theOutputFile = new TOutputObjectFile( drecfile );
  Tcout << "event data outputs into " << drecfile << Tendl;

  theCrate -> Initialize( "run begin" );

  TSoftwareScalerModule* runid =
    (TSoftwareScalerModule*)( theCrate -> GetModule( "runid" ) );
  runid -> SetData( 0, aRun.GetRunID() );

  TDataRecord record =
    theReadoutBook -> GetReadoutList( "RUN BEGIN" ) -> Read();
  *theOutputFile << record;

  theOutputHtml.Open( htmlfile );
  Tcout << "run summary outputs into " << htmlfile << Tendl;
  theRunSummary = new St00RunSummary();
  fillRunBeginInformation( record );

  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint veto = envtable.GetIntegerValue( "ST00_RPV130_OUT_VETO" );
  Tint stop = envtable.GetIntegerValue( "ST00_RPV130_OUT_STOP" );
  TVmeRpv130Module* rpv130 =
    (TVmeRpv130Module*)( theCrate -> GetModule( "rpv130" ) );

  rpv130 -> Pulse( stop );
  rpv130 -> LevelUp( veto );

  return;
}

Tvoid St00RunAction::EndOfRunAction( TRun& aRun )
{
  TDataRecord record =
    theReadoutBook -> GetReadoutList( "RUN END" ) -> Read();
  *theOutputFile << record;

  fillRunEndInformation( record );
  Tstring title = "Run Summary #" + (theRunManager->GetRun()).GetStringRunID();
  theOutputHtml.SetTitle( title );
  theOutputHtml << theRunSummary -> GenerateRunSummaryTable() << Tendl;
  theOutputHtml.Close();



  Tstring htmlfile = theOutputHtml.GetFileName();
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint autoprint = envtable.GetIntegerValue( "ST00_AUTO_PRINT" );
  if ( autoprint ) {
    // http://www.tdb.uu.se/~jan/html2ps.html
    Tstring command = "html2ps " + htmlfile + " | lpr";
    system( command.c_str() );
  }

  delete theRunSummary;
  delete theOutputFile;
  theRunSummary = 0;
  theOutputFile = 0;


  return;
}

Tvoid St00RunAction::setFileName( Tint runid, Tstring& drecfile, Tstring& htmlfile )
{
  static const Tstring drecext = ".drec";
  static const Tstring htmlext = ".html";

  Tstring filehead = "run";
  Tstring runidstr = itostr( runid );

  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();

  Tstring drecdir = envtable.GetEnvironmentValue( "ST00_RECORD_DIR" );
  Tstring htmldir = envtable.GetEnvironmentValue( "ST00_SUMMARY_DIR" );
  Tint overwrite = envtable.GetIntegerValue( "ST00_OVERWRITE_ENABLE" );


  if ( runid < 10 ) {
    filehead += "00";
  } else if ( runid < 100 ) {
    filehead += "0";
  }

  drecfile = drecdir + Tslash + filehead + runidstr + drecext;
  htmlfile = htmldir + Tslash + filehead + runidstr + htmlext;

  if ( overwrite == 0 ) {
    if ( isexist( drecfile ) ) {
      Tcout << "already exist " << drecfile << "." << Tendl;
      drecfile = drecdir + Tslash + "TEMP" + filehead + runidstr + drecext;
    }
    if ( isexist( htmlfile ) ) {
      Tcout << "already exist " << htmlfile << "." << Tendl;
      htmlfile = htmldir + Tslash + "TEMP" + filehead + runidstr + htmlext;
    }
  }
  

  return;
}

Tvoid St00RunAction::fillRunBeginInformation( const TDataRecord& record )
{
  static Tstring runidset[ 3 ] = { "INFO", "RUN ID", "0" };
  static Tstring clockset[ 3 ] = { "INFO", "CLOCK", "0" };

  TDataElement runid;
  TDataElement clock;
  record.FindDataElement( runidset, runid );
  record.FindDataElement( clockset, clock );

  theRunSummary -> SetRecordName( theOutputFile -> GetFileName() );
  theRunSummary -> SetRunID( *( runid.GetIntData() ) );
  theRunSummary -> SetRunBeginTime( *( clock.GetStringData() ) );

  return;
}

Tvoid St00RunAction::fillRunEndInformation( const TDataRecord& record )
{
  static Tstring clockset[ 3 ] = { "INFO", "CLOCK", "0" };
  TDataElement clock;
  record.FindDataElement( clockset, clock );

  TRunInformationTable table = theRunManager -> GetRunInformationModule() -> GetRunInformationTable();
  theRunSummary -> SetRunInformationTable( table );
  theRunSummary -> SetRunEndTime( *( clock.GetStringData() ) );
  theRunSummary -> SetRecordSize( theOutputFile -> GetTotalDataSize() );

  return;
}
