// =====================================================================
//  $Id: OFFdrkdivide.cc,v 1.4 2003/07/30 16:16:10 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: OFFdrkdivide.cc,v $
//  Revision 1.4  2003/07/30 16:16:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TEnvironmentVariableTable.hh"
#include "Trootinit.h"
#include "St01OfflineDarkAverageMap.hh"
#include "St01OfflineDarkRmsMap.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <dark ID>" << Tendl;
    return( -1 );
  }

  TApplication* theApplication = rootinit();
  TGaxis::SetMaxDigits( 2 );

  TCanvas CVdrk( "CVdrk", "Dark Current Distribution by Pixel", 480, 720 );
  CVdrk.ToggleEventStatus();
  CVdrk.Divide(1,2);
  TH1D H1Ddrk( "H1Ddrk", "Dark Current Average by Pixel", 100, -50.0, 50.0 );
  TH1D H1Drms( "H1Drms", "RMS of D.C. by Pixel", 50, 0.0, 50.0 );
  H1Ddrk.GetXaxis()->SetTitle("Pulseheight (ADU)");
  H1Ddrk.GetXaxis()->CenterTitle();
  H1Ddrk.GetXaxis()->SetNoExponent();
  H1Ddrk.GetYaxis()->SetTitle("Counts");
  H1Ddrk.GetYaxis()->CenterTitle();
  H1Drms.GetXaxis()->SetTitle("Pulseheight (ADU)");
  H1Drms.GetXaxis()->CenterTitle();
  H1Drms.GetXaxis()->SetNoExponent();
  H1Drms.GetYaxis()->SetTitle("Counts");
  H1Drms.GetYaxis()->CenterTitle();





  TCanvas CVdrkHdivide( "CVdrkHdivide", "Divide Horizontal", 960, 720 );
  CVdrkHdivide.ToggleEventStatus();
  CVdrkHdivide.Divide(4,4);

  TCanvas CVdrkVdivide( "CVdrkVdivide", "Divide Vertical", 960, 720 );
  CVdrkVdivide.ToggleEventStatus();
  CVdrkVdivide.Divide(4,4);

  // file̾η
  TEnvironmentVariableTable envtable( "st01setup" );
  Tint drkid = strtol( argv[ 1 ], 0, 0 );
  Tstring drkf = envtable.GetEnvironmentValue( "ST01_RECORD_DIR" ) + "/run";
  drkf += itostr( drkid ) + ".drec";

  // ʬطѥ᡼
  const Tint hdivide = envtable.GetIntegerValue( "ST01_CTI_HDIVIDE" );
  const Tint vdivide = envtable.GetIntegerValue( "ST01_CTI_VDIVIDE" );
  Tint nh = envtable.GetIntegerValue( "ST01_HPIXEL" );
  Tint nv = envtable.GetIntegerValue( "ST01_VPIXEL" );
  Tint hpitch = nh / vdivide;
  Tint vpitch = nv / hdivide;




  //==================================================================
  //                                          ___________
  // ˥ե졼ʬ䤷HCTI    |  |  |  |  |
  //                                         |  |  |  |  |
  //                                         |  |  |  |  |
  //                                         |  |  |  |  |
  //                                         |__|__|__|__|
  //
  //==================================================================
  TH1D* H1Dvdivide = new TH1D[ vdivide ];
  for ( Tint i = 0; i < vdivide; i ++ ) {
    H1Dvdivide[ i ].SetBins( 100, -50.0, 50.0 );
    Tstring title = "D.C. Position Dep., Vertical Partition: " + itostr( i, 0 );
    H1Dvdivide[ i ].SetTitle( title.c_str() );
    Tstring name = "H1Dvdivide" + itostr( i, 3 );
    H1Dvdivide[ i ].SetName( name.c_str() );
    H1Dvdivide[ i ].GetXaxis()->SetTitle("Pulseheight (ADU)");
    H1Dvdivide[ i ].GetXaxis()->CenterTitle();
    H1Dvdivide[ i ].GetXaxis()->SetNoExponent();
    H1Dvdivide[ i ].GetYaxis()->SetTitle("Counts");
    H1Dvdivide[ i ].GetYaxis()->CenterTitle();
  }

  for ( Tint cv = 0; cv < 16; cv ++ ) {
    CVdrkVdivide.cd( cv + 1 );
    H1Dvdivide[ cv ].Draw();
  }


  //==================================================================
  //                                         ________
  // ˥ե졼ʬ䤷VCTI   |________|
  //                                        |________|
  //                                        |________|
  //                                        |________|
  //
  //==================================================================
  //ΰʬΥҥȤäɽ
  TH1D* H1Dhdivide = new TH1D[ hdivide ];
  for ( Tint i = 0; i < hdivide; i ++ ) {
    H1Dhdivide[ i ].SetBins( 100, -50.0, 50.0 );
    Tstring title = "D.C. Position Dep., Horizontal Partition: " + itostr( i, 0 );
    H1Dhdivide[ i ].SetTitle( title.c_str() );
    Tstring name = "H1Dhdivide" + itostr( i, 3 );
    H1Dhdivide[ i ].SetName( name.c_str() );
    H1Dhdivide[ i ].GetXaxis()->SetTitle("Pulseheight (ADU)");
    H1Dhdivide[ i ].GetXaxis()->CenterTitle();
    H1Dhdivide[ i ].GetXaxis()->SetNoExponent();
    H1Dhdivide[ i ].GetYaxis()->SetTitle("Counts");
    H1Dhdivide[ i ].GetYaxis()->CenterTitle();
  }

  for ( Tint cv = 0; cv < 16; cv ++ ) {
    CVdrkHdivide.cd( cv + 1 );
    H1Dhdivide[ cv ].Draw();
  }




  St01OfflineDarkRmsMap map( drkf );
  const TDataMultiplicity& rms = map.GetMap();
  const TDataMultiplicity& ave = map.GetOfflineDarkAverageMap().GetMap();
  for ( Tint h = 0; h < ave.num_col(); h ++ ) {
    for ( Tint v = 0; v < ave.num_row(); v ++ ) {
      H1Ddrk.Fill( ave[ v ][ h ] );
      H1Drms.Fill( rms[ v ][ h ] );
      H1Dhdivide[ v/vpitch ].Fill( ave[ v ][ h ] );
      H1Dvdivide[ h/hpitch ].Fill( ave[ v ][ h ] );
    }
  }

  CVdrk.cd(1);
  H1Ddrk.Draw();
  CVdrk.cd(2);
  H1Drms.Draw();
  CVdrk.cd();

  theApplication -> Run();
  return( 0 );
}
