// =====================================================================
//  $Id: St01RunInformationExtractor.hh,v 1.2 2003/07/30 16:16:11 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: St01RunInformationExtractor.hh,v $
//  Revision 1.2  2003/07/30 16:16:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __ST01RUNINFORMATIONEXTRACTOR_HH
#define __ST01RUNINFORMATIONEXTRACTOR_HH

#include "Tglobals.h"

class St01RunInformationExtractor
{

  private:
    Tstring theRecordPath;
    TstringList theElementTags;
    TstringList theElements;

  public:
    St01RunInformationExtractor( const Tstring& recpath );
    ~St01RunInformationExtractor();

  public:
    friend Tostream& operator<<( Tostream& tos, const St01RunInformationExtractor& right );

  public:
    const Tstring& GetRecordPath() const;
    const TstringList& GetElementTags() const;
    const TstringList& GetElements() const;
    const Tstring& GetElementTag( Tint index ) const;
    const Tstring& GetElement( Tint index ) const;

};

inline const Tstring& St01RunInformationExtractor::GetRecordPath() const
{
  return( theRecordPath );
}

inline const TstringList& St01RunInformationExtractor::GetElementTags() const
{
  return( theElementTags );
}

inline const TstringList& St01RunInformationExtractor::GetElements() const
{
  return( theElements );
}

inline const Tstring& St01RunInformationExtractor::GetElementTag( Tint index ) const
{
  return( theElementTags[ index ] );
}

inline const Tstring& St01RunInformationExtractor::GetElement( Tint index ) const
{
  return( theElements[ index ] );
}

#endif
