// =====================================================================
//  $Id: st02OFFspfind.cc,v 1.1 2003/09/09 22:19:49 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: st02OFFspfind.cc,v $
//  Revision 1.1  2003/09/09 22:19:49  goiwai
//  ޤ,OFFxxx.ccȤե̾äե饤ѤΥץ
//  st02OFFxxx.ccѹޤ.
//  ե̾ɻߤŪǤ.
//
//  Revision 1.2  2003/07/30 16:16:33  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TEnvironmentVariableTable.hh"
#include "TInputObjectFile.hh"
#include "Trootinit.h"

#include "St02OfflineDarkAverageMap.hh"
#include "St02OfflineDarkRmsMap.hh"
#include "St02SinglePixelInterface.hh"
#include "St02SinglePixelList.hh"
#include "St02DataRecordConversion.hh"
#include "St02RunInformationExtractor.hh"
#include "St02BadChannelMap.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 3 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <dark ID> <source ID>" << Tendl;
    return( -1 );
  }

  TApplication* theApplication = rootinit();
  TCanvas CVspfind( "CVspfind", "Findout SINGLE PIXEL EVENTs", 720, 810 );
  CVspfind.ToggleEventStatus();
  CVspfind.Divide( 2, 3 );
  //󥰥ԥ륤٥ȤΥʥADC
  TH1D H1Dsignal( "H1Dsignal", "Single Pixel Event subtracted D.C.", 100, 0.0, 500.0 );
  //Υԥ˱ȤADCȤʿ
  //Ʊ饤H.O.C.ʿѤϰƤ
  TH1D H1Ddark( "H1Ddark", "Dark Current subtracted H.O.C.", 100, -50.0, 50.0 );
  //Υԥ˱RMSADCȤʿ
  TH1D H1Drms( "H1Drms", "RMS of D.C.", 50, 0.0, 50.0 );
  //Ͼƥ
  TPaveText PTdinfo( 0.0, 0.0, 1.0, 1.0 );  //
  TPaveText PTsinfo( 0.0, 0.0, 1.0, 1.0 );  //ξ
  TPaveText PTainfo( 0.0, 0.0, 1.0, 1.0 );  //Ϸ̤ξ
  PTdinfo.SetName("PTdinfo");
  PTsinfo.SetName("PTsinfo");
  PTainfo.SetName("PTainfo");


  CVspfind.cd( 1 );
  H1Ddark.Draw();
  CVspfind.cd( 2 );
  H1Drms.Draw();
  CVspfind.cd( 3 );
  H1Dsignal.Draw();
  CVspfind.cd( 4 );
  PTdinfo.Draw();
  CVspfind.cd( 5 );
  PTsinfo.Draw();
  CVspfind.cd( 6 );
  PTainfo.Draw();



  // file̾η
  TEnvironmentVariableTable envtable( "st02setup" );
  Tint drkid = strtol( argv[ 1 ], 0, 0 );
  Tint srcid = strtol( argv[ 2 ], 0, 0 );
  Tstring drkf = envtable.GetEnvironmentValue( "ST02_RECORD_DIR" ) + "/run";
  Tstring srcf = envtable.GetEnvironmentValue( "ST02_RECORD_DIR" ) + "/run";
  drkf += itostr( drkid ) + ".drec";
  srcf += itostr( srcid ) + ".drec";


  // 󥰥ԥ륤٥ȤΥե̾
  Tstring outpath = envtable.GetEnvironmentValue( "ST02_SPDATASET_DIR" );
  Tstring darkrunid = itostr( drkid );
  Tstring sourcerunid = itostr( srcid );

  Tstring th=envtable.GetEnvironmentValue( "ST02_SPIXEL_THRESHOLD_SIGMA" );
  Tstring ar=envtable.GetEnvironmentValue( "ST02_SPIXEL_NO_AROUND_SIGMA" );
  outpath += "/" + th + "sigma" + ar + "sigma";
  if ( !isexist( outpath ) ) {
    Tcerr << "No such file or directory: " << outpath << Tendl;
    return( -1 );
  }
  outpath += "/drk" + darkrunid + "src" + sourcerunid;


  Tstring outdat = outpath + ".dat";
  Tstring outps = outpath + ".ps";
  Tstring outgif = outpath + ".gif";
  Tstring outC = outpath + ".C";
  Tstring outroot = outpath + ".root";
  if ( envtable.GetIntegerValue( "ST02_OVERWRITE_ENABLE" ) == 0 ) {
    if ( isexist( outdat ) ) {
      Tcerr << "already exist " << outdat << Tendl;
      return( -1 );
    }
  }

  Tcout << "DARK RUN:   " << drkf << Tendl;
  Tcout << "SOURCE RUN: " << srcf << Tendl;
  Tcout << "OUTPUT:     " << outdat << Tendl;


  St02SinglePixelInterface spif( drkf, srcf );

  
  //const TDataMultiplicity& bad = spif.GetBadChannelMap()->GetMap();
  const TDataMultiplicity& rms = spif.GetBadChannelMap()->GetOfflineDarkRmsMap().GetMap();
  const TDataMultiplicity& ave = spif.GetBadChannelMap()->GetOfflineDarkRmsMap().GetOfflineDarkAverageMap().GetMap();

  for ( Tint row = 0; row < ave.num_row(); row ++ ) {
    for ( Tint col = 0; col < ave.num_col(); col ++ ) {
      //if ( badmap.IsGoodChannel( row, col ) ) {
      H1Ddark.Fill( ave[ row ][ col ] );
      H1Drms.Fill( rms[ row ][ col ] );
      //}
    }
  }
  TGaxis::SetMaxDigits( 2 );
  H1Ddark.GetXaxis()->SetTitle("Pulseheight (ADU)");
  H1Ddark.GetXaxis()->CenterTitle();
  H1Ddark.GetXaxis()->SetNoExponent();
  H1Ddark.GetYaxis()->SetTitle("Counts");
  H1Ddark.GetYaxis()->CenterTitle();

  H1Drms.GetXaxis()->SetTitle("Pulseheight (ADU)");
  H1Drms.GetXaxis()->CenterTitle();
  H1Drms.GetXaxis()->SetNoExponent();
  H1Drms.GetYaxis()->SetTitle("Counts");
  H1Drms.GetYaxis()->CenterTitle();

  CVspfind.GetPad(1)->Modified();
  CVspfind.GetPad(1)->Update();
  CVspfind.GetPad(2)->Modified();
  CVspfind.GetPad(2)->Update();



  const St02SinglePixelList& splist = spif.GetSinglePixelList();
  Tofstream ofs;
  ofs.open( outdat.c_str() );
  for ( Tsize_t i = 0; i < splist.size(); i ++ ) {
    H1Dsignal.Fill( splist[ i ].GetSignal() );
    ofs << splist[ i ] << Tendl;
  }
  ofs.close();

  H1Dsignal.GetXaxis()->SetTitle("Pulseheight (ADU)");
  H1Dsignal.GetXaxis()->CenterTitle();
  H1Dsignal.GetXaxis()->SetNoExponent();
  H1Dsignal.GetYaxis()->SetTitle("Counts");
  H1Dsignal.GetYaxis()->CenterTitle();

  CVspfind.GetPad(3)->Modified();
  CVspfind.GetPad(3)->Update();


  
  const char* tmppath = "ST02TMPFILE";
  Tofstream tofs;

  PTdinfo.SetFillColor( 10 );
  PTdinfo.SetFillStyle( 0 );
  PTdinfo.SetBorderSize( 0 );
  tofs.open( tmppath );
  St02RunInformationExtractor dext( drkf );
  tofs << dext << Tendl;
  PTdinfo.ReadFile( tmppath );
  tofs.close();
  remove( tmppath );


  PTsinfo.SetFillColor( 10 );
  PTsinfo.SetFillStyle( 0 );
  PTsinfo.SetBorderSize( 0 );
  tofs.open( tmppath );
  St02RunInformationExtractor sext( srcf );
  tofs << sext << Tendl;
  PTsinfo.ReadFile( tmppath );
  tofs.close();
  remove( tmppath );


  PTainfo.SetFillColor( 10 );
  PTainfo.SetFillStyle( 0 );
  PTainfo.SetBorderSize( 0 );
  PTainfo.SetTextSize( 0.06 );
  tofs.open( tmppath );
  TstringList items;
  items.push_back( "ST02_VSHIFT_CYCLE" );
  items.push_back( "ST02_HPIXEL" );
  items.push_back( "ST02_VPIXEL" );
  items.push_back( "ST02_HOFFSET" );
  items.push_back( "ST02_VOFFSET" );
  items.push_back( "ST02_HOC_PIXEL" );
  items.push_back( "ST02_BAD_THRESHOLD_RMS" );
  items.push_back( "ST02_BAD_OVERFLOW" );
  items.push_back( "ST02_SPIXEL_THRESHOLD_SIGMA" );
  items.push_back( "ST02_SPIXEL_NO_AROUND_SIGMA" );
  for ( Tsize_t i = 0; i < items.size(); i ++ ) {
    tofs << items[i] << ": " << envtable.GetEnvironmentValue( items[i] ) << Tendl;
  }
   PTainfo.ReadFile( tmppath );
   tofs.close();
   remove( tmppath );




  CVspfind.GetPad(4)->Modified();
  CVspfind.GetPad(4)->Update();
  CVspfind.GetPad(5)->Modified();
  CVspfind.GetPad(5)->Update();
  CVspfind.GetPad(6)->Modified();
  CVspfind.GetPad(6)->Update();

  CVspfind.cd();

  CVspfind.Print( outps.c_str() );
  CVspfind.Print( outgif.c_str() );
  CVspfind.Print( outC.c_str() );

  TFile f( outroot.c_str(), "RECREATE", "SINGLE PIXEL EVENTs" );
  H1Ddark.Write();
  H1Drms.Write();
  H1Dsignal.Write();
  PTdinfo.Write();
  PTsinfo.Write();
  PTainfo.Write();
  CVspfind.Write();
  f.Close();


  //theApplication -> Run();
  theApplication -> Terminate();

  return( 0 );
}
