// =====================================================================
//  $Id: TMatrixElement.cc,v 1.2 2003/07/30 16:17:11 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: TMatrixElement.cc,v $
//  Revision 1.2  2003/07/30 16:17:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TMatrixElement.hh"

TMatrixElement::TMatrixElement( const Tstring& idstr, Tobject_t objecttype, Tint ndata, Tint ntuple )
  : TDataMultiplicity( ndata, ntuple ), theMatrixID( idstr ), 
    theObjectType( objecttype )
{;}

TMatrixElement::TMatrixElement( const TMatrixElement& right )
  : TDataMultiplicity( right ), theMatrixID( right.theMatrixID ),
    theObjectType( right.theObjectType )
{;}

TMatrixElement::~TMatrixElement()
{;}

const TMatrixElement& TMatrixElement::operator=( const TMatrixElement& right )
{
  *( (TDataMultiplicity*)this ) = *( (TDataMultiplicity*)(&right) );
  theMatrixID = right.theMatrixID;
  theObjectType = right.theObjectType;
  return( *this );
}

Tbool TMatrixElement::operator==( const TMatrixElement& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( *( (TDataMultiplicity*)this ) == *( (TDataMultiplicity*)(&right) ) );
  retval &= ( theMatrixID == right.theMatrixID );
  retval &= ( theObjectType == right.theObjectType );
  return( retval );
}

Tbool TMatrixElement::operator!=( const TMatrixElement& right ) const
{
  Tbool retval = Tfalse;
  retval |= !( ( *( (TDataMultiplicity*)this ) == *( (TDataMultiplicity*)(&right) ) ) );
  retval |= ( theMatrixID != right.theMatrixID );
  retval |= ( theObjectType != right.theObjectType );
  return( retval );
}
