// =====================================================================
//  $Id: TMatrixElement.hh,v 1.2 2003/07/30 16:17:11 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: TMatrixElement.hh,v $
//  Revision 1.2  2003/07/30 16:17:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TMATRIXELEMENT_HH
#define __TMATRIXELEMENT_HH

#include "Tglobals.h"
#include "TDataMultiplicity.hh"

class TMatrixElement
  : public TDataMultiplicity
{

  private:
    Tstring theMatrixID;
    Tobject_t theObjectType;

  public:
    TMatrixElement( const Tstring& idstr = "", Tobject_t objecttype = tObjectUnknown, Tint ndata = 0, Tint ntuple = 0 );
    TMatrixElement( const TMatrixElement& right );
    ~TMatrixElement();

  public:
    const TMatrixElement& operator=( const TMatrixElement& right );
    Tbool operator==( const TMatrixElement& right ) const;
    Tbool operator!=( const TMatrixElement& right ) const;

  public:
    const Tstring& GetMatrixID() const;
    Tstring& GetMatrixID();
    Tvoid SetMatrixID( const Tstring& id );
    Tobject_t GetObjectType() const;
    Tvoid SetObjectType( Tobject_t objecttype );

  public:
    Tint GetNumberOfTuples() const;
    Tint GetNumberOfEvents() const;

};

inline const Tstring& TMatrixElement::GetMatrixID() const
{
  return( theMatrixID );
}

inline Tstring& TMatrixElement::GetMatrixID()
{
  return( theMatrixID );
}

inline Tvoid TMatrixElement::SetMatrixID( const Tstring& id )
{
  theMatrixID = id;
  return;
}

inline Tint TMatrixElement::GetNumberOfTuples() const
{
  return( num_col() );
}

inline Tint TMatrixElement::GetNumberOfEvents() const
{
  return( num_row() );
}

inline Tobject_t TMatrixElement::GetObjectType() const
{
  return( theObjectType );
}

inline Tvoid TMatrixElement::SetObjectType( Tobject_t objecttype )
{
  theObjectType = objecttype;
  return;
}

#endif
