// =====================================================================
//  $Id: TSleepCommand.cc,v 1.4 2003/08/25 10:42:21 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: TSleepCommand.cc,v $
//  Revision 1.4  2003/08/25 10:42:21  goiwai
//  Ǥ.äѤꥹåɤ˻ߤޤޤ.ߤޤ.
//  , /system/execute ʤ褦Ǥ.
//  ᡹,ľޤ.
//
//  Revision 1.3  2003/08/25 10:37:14  goiwai
//  sleep,åɤ˥꡼פƤޤΤ,ҥץä,
//  sleep褦ˤޤ.EventLoopư³ޤ.
//  ˤä,ʤˤ뤫Ȥ,
//  /run/start
//  /system/sleep 10
//  /run/suspend
//  /run/stop
//  Ȥäޥ򿩤碌뤳Ȥˤä,10äΥ¹ԤϤǤ.
//
//  Revision 1.2  2003/07/30 16:17:33  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TSleepCommand.hh"
#include "TRunManager.hh"

static const Tstring _name = "/system/sleep";
static const Tstring _desc = "sleep a parent process.\nsome thread processes go on.\nexample> sleep 10";

TSleepCommand::TSleepCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TSleepCommand::~TSleepCommand()
{;}

Tvoid TSleepCommand::Execute( const TstringList& arguments )
{
  // åɤ˻ߤޤä㤦

  if ( arguments.empty() ) {
    ShowCommandDetail();
  } else {

    Tstring strtime = arguments[ 0 ];
    for ( Tsize_t i = 0; i < strtime.size(); i ++ ) {
      if ( isdigit( strtime[ i ] ) == 0 ) {
        Tcerr << "TSleepCommand::Execute: invalid time " << strtime << "." << Tendl;
        return;
      }
    }

    Tpid_t parent = getpid();
    TUint timesec = strtoul( strtime.c_str(), 0, 0 );

    if ( fork() == 0 ) {
      sleep( timesec );
      exit( 0 );
    } else if ( getpid() == parent ) {
      wait( 0 );
    } else {
      Tcerr << "TSleepCommand::Execute: fork error." << Tendl;
    }
  }

  return;
}
