// =====================================================================
//  $Id: TDataSection.hh,v 1.3 2003/08/25 09:20:29 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: TDataSection.hh,v $
//  Revision 1.3  2003/08/25 09:20:29  goiwai
//  operator[]( const Tstring& id ) äޤ.
//  record[0] Ȥ record["tag"] Ȥ, TDataSegment 뤳Ȥ
//  ޤ.
//  size()ۤϰϤˤ,åʤǥޤ.
//  ޥåʤäޤ.
//  Ʊ̾ǥ줿 DataSegment ,ǽ˥ޥåΤ֤
//  Ƥޤ.
//
//  Revision 1.2  2003/07/30 16:17:51  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TDATASECTION_HH
#define __TDATASECTION_HH

#include "Tglobals.h"
#include "TStreamableObject.hh"
#include "TDataSegmentList.hh"

class TOutputObjectStream;
class TOutputObjectFile;
class TOutputObjectSocket;
class TOutputObjectSharedMemory;

class TDataSection
  : public TStreamableObject, public TDataSegmentList
{

  public:
    TDataSection( const Tstring& id = TunknownID );
    TDataSection( const TDataSection& right );  
    ~TDataSection();

  public:
    Tint GetRecordSize();
    Tint Record( TOutputObjectStream* objectfile );
    Tvoid Clear();
    Tint Serialize( Tvoid* buffer );

  public:
    const TDataSection& operator=( const TDataSection& right );
    Tbool operator==( const TDataSection& right ) const;
    Tbool operator!=( const TDataSection& right ) const;
    const TDataSegment& operator[]( Tint n ) const;
    TDataSegment& operator[]( Tint n );
    const TDataSegment& operator[]( const Tstring& id ) const;
    TDataSegment& operator[]( const Tstring& id );
    friend Tostream& operator<<( Tostream& tos, const TDataSection& right );

  public:
    Tbool FindDataSegment( const Tstring& id, TDataSegment& segment ) const;
    Tint FindDataSegment( const Tstring& id ) const;
    Tbool FindDataElement( const Tstring& segid, const Tstring& eleid, TDataElement& element ) const;
    Tint FindDataElement( const Tstring& segid, const Tstring& eleid ) const;
    Tbool FindDataElement( Tstring idset[ 2 ], TDataElement& element ) const;
    Tint FindDataElement( Tstring idset[ 2 ] ) const;
    Tbool FindDataElement( const TstringList& idset, TDataElement& element ) const;
    Tint FindDataElement( const TstringList& idset ) const;

  private:
    Tint record( TOutputObjectFile* ofile );
    Tint record( TOutputObjectSocket* osocket );
    Tint record( TOutputObjectSharedMemory* omemory );

};

#endif
