// =====================================================================
//  $Id: TStreamableObject.hh,v 1.2 2003/07/30 16:17:51 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: TStreamableObject.hh,v $
//  Revision 1.2  2003/07/30 16:17:51  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TSTREAMABLEOBJECT_HH
#define __TSTREAMABLEOBJECT_HH

#include "Tglobals.h"

class TOutputObjectStream;

class TStreamableObject
{

  protected:
    Tobject_t theObjectType;
    Tstring theID;

  public:
    TStreamableObject( Tobject_t objecttype, const Tstring& id );
    TStreamableObject( const TStreamableObject& right );

  public:
    Tobject_t GetObjectType() const;
    const Tstring& GetID() const;
    Tvoid SetObjectType( Tobject_t objecttype );
    Tvoid SetID( const Tstring& id );

  public:
    virtual const TStreamableObject& operator=( const TStreamableObject& right );
    virtual Tbool operator==( const TStreamableObject& right ) const;
    virtual Tbool operator!=( const TStreamableObject& right ) const;

  protected:
    virtual ~TStreamableObject();

  public:
    virtual Tint GetRecordSize() = 0;
    virtual Tint Record( TOutputObjectStream* output ) = 0;
    virtual Tvoid Clear() = 0;
    virtual Tint Serialize( Tvoid* buffer ) = 0;

};

inline Tobject_t TStreamableObject::GetObjectType() const
{
  return( theObjectType );
}

inline const Tstring& TStreamableObject::GetID() const
{
  return( theID );
}

inline Tvoid TStreamableObject::SetObjectType( Tobject_t objecttype )
{ 
  theObjectType = objecttype;
  return;
}

inline Tvoid TStreamableObject::SetID( const Tstring& id )
{
  theID = id;
  return;
}

#endif
