// =====================================================================
//  $Id: TModuleSpecified.hh,v 1.2 2003/07/30 16:19:10 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: TModuleSpecified.hh,v $
//  Revision 1.2  2003/07/30 16:19:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TMODULESPECIFIED_HH
#define __TMODULESPECIFIED_HH

#include "Tglobals.h"

class TModule;

class TModuleSpecified
{

  private:
    Tstring theModuleID;
    TstringList theGroupIDs;
    TModule* theModule;

  public:
    TModuleSpecified();
    TModuleSpecified( const Tstring& id, const TstringList& groups, TModule* module );
    TModuleSpecified( const TModuleSpecified& right );
    ~TModuleSpecified();

  public:
    const TModuleSpecified& operator=( const TModuleSpecified& right );
    Tbool operator==( const TModuleSpecified& right ) const;
    Tbool operator!=( const TModuleSpecified& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TModuleSpecified& right );

  public:
    const Tstring& GetModuleID() const;
    Tstring& GetModuleID();
    const TstringList& GetGroupIDs() const;
    TstringList& GetGroupIDs();
    TModule* GetModule() const;
    Tvoid SetModuleID( const Tstring& id );
    Tvoid SetGroupIDs( const TstringList& ids );
    Tvoid SetModule( TModule* module );
    Tbool IsSameGroup( const TModuleSpecified& spec );
    Tbool IsSameGroup( const TstringList& groups );
    Tbool IsSameGroup( const Tstring& group );

};

inline const Tstring& TModuleSpecified::GetModuleID() const
{
  return( theModuleID );
}

inline Tstring& TModuleSpecified::GetModuleID()
{
  return( theModuleID );
}

inline const TstringList& TModuleSpecified::GetGroupIDs() const
{
  return( theGroupIDs );
}

inline TstringList& TModuleSpecified::GetGroupIDs()
{
  return( theGroupIDs );
}

inline TModule* TModuleSpecified::GetModule() const
{
  return( theModule );
}

inline Tvoid TModuleSpecified::SetModuleID( const Tstring& id )
{
  theModuleID = id;
  return;
}

inline Tvoid TModuleSpecified::SetGroupIDs( const TstringList& ids )
{
  theGroupIDs = ids;
  return;
}

inline Tvoid TModuleSpecified::SetModule( TModule* module )
{
  theModule = module;
  return;
}

#endif
