// =====================================================================
//  $Id: TSoftwareScalerModule.cc,v 1.2 2003/07/30 16:19:11 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: TSoftwareScalerModule.cc,v $
//  Revision 1.2  2003/07/30 16:19:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TSoftwareScalerModule.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TSoftwareScalerModule::TSoftwareScalerModule( Tint nchannel )
  : TSoftwareModule( nchannel ), theChannel( nchannel, 0 )
{;}

TSoftwareScalerModule::TSoftwareScalerModule( const TSoftwareScalerModule& right )
  : TSoftwareModule( right ), theChannel( right.theChannel )
{;}

TSoftwareScalerModule::~TSoftwareScalerModule()
{;}

Tvoid TSoftwareScalerModule::FillData( TDataElement& element, Tint channel )
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TSoftwareScalerModule::FillData: invalid ID " << channel << Tendl;
    theStatus = -EFAULT;
    element.FillData( &theStatus, tTypeInt, 1 );
  } else {
    element.FillData( &theChannel[ channel ], tTypeInt, 1 );
  }
  return;
}

const TSoftwareScalerModule& TSoftwareScalerModule::operator=( const TSoftwareScalerModule& right )
{
  *( (TSoftwareModule*)this ) = *( (TSoftwareModule*)(&right) );
  theChannel = right.theChannel;
  return( *this );
}

Tbool TSoftwareScalerModule::operator==( const TSoftwareScalerModule& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TSoftwareModule*)this ) == *( (TSoftwareModule*)(&right) ) );
  ret &= ( theChannel == right.theChannel );
  return( ret );
}

Tbool TSoftwareScalerModule::operator!=( const TSoftwareScalerModule& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TSoftwareModule*)this ) != *( (TSoftwareModule*)(&right) ) );
  ret |= ( theChannel != right.theChannel );
  return( ret );
}
