// =====================================================================
//  $Id: TInputObjectFile.hh,v 1.2 2003/07/30 16:19:30 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: TInputObjectFile.hh,v $
//  Revision 1.2  2003/07/30 16:19:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TINPUTOBJECTFILE_HH
#define __TINPUTOBJECTFILE_HH

#include "Tglobals.h"
#include "TObjectFile.hh"
#include "TInputObjectStream.hh"

class TStreamableObject;
class TDataRecord;
class TDataSection;
class TDataSegment;
class TDataElement;
class TObjectFilter;

class TInputObjectFile
  : public TObjectFile, public TInputObjectStream
{

  public:
    TInputObjectFile( const Tstring& filename, const Tstring& mode = "r" );
    TInputObjectFile( TObjectFilter* filter, const Tstring& filename, const Tstring& mode = "r" );
    ~TInputObjectFile();

  public:
    Tint Read( TStreamableObject& object );
  
  private:
    TDataRecord getDataRecord();
    TDataSection getDataSection();
    TDataSegment getDataSegment();
    TDataElement getDataElement();
    Tvoid readProperties( Tint& recsize, Tobject_t& type, Tstring& id, Tsize_t& entries );

};

#endif
