// =====================================================================
//  $Id: TInputObjectSharedMemory.hh,v 1.2 2003/07/30 16:19:30 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: TInputObjectSharedMemory.hh,v $
//  Revision 1.2  2003/07/30 16:19:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TINPUTOBJECTSHAREDMEMORY_HH
#define __TINPUTOBJECTSHAREDMEMORY_HH

#include "Tglobals.h"
#include "TObjectSharedMemory.hh"
#include "TInputObjectStream.hh"

class TStreamableObject;
class TObjectFilter;
class TDataRecord;
class TDataSection;
class TDataSegment;
class TDataElement;

class TInputObjectSharedMemory
  : public TObjectSharedMemory, public TInputObjectStream
{

  private:
    Tbool theReadSuccessFlag;

  public:
    TInputObjectSharedMemory( Tint memsize = tDefaultMemorySize, Tint maxevt = tDefaultMaxEvent );
    TInputObjectSharedMemory( TObjectFilter* filter, Tint memsize = tDefaultMemorySize, Tint maxevt = tDefaultMaxEvent );
    ~TInputObjectSharedMemory();

  public:
    Tint Read( TStreamableObject& object );

  public:
    Tbool IsReadSuccess() const;

  private:
    TDataRecord getDataRecord();
    TDataSection getDataSection();
    TDataSegment getDataSegment();
    TDataElement getDataElement();
    Tvoid readProperties( Tint& recsize, Tobject_t& type, Tstring& id, Tsize_t& entries );
};

inline Tbool TInputObjectSharedMemory::IsReadSuccess() const
{
  return( theReadSuccessFlag );
}

#endif
