// =====================================================================
//  $Id: TRunInformationTable.hh,v 1.2 2003/07/30 16:20:31 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: TRunInformationTable.hh,v $
//  Revision 1.2  2003/07/30 16:20:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TRUNINFORMATIONTABLE_HH
#define __TRUNINFORMATIONTABLE_HH

#include "Tglobals.h"
#include "TRunInformationList.hh"

class TOutputHtmlFileStream;

class TRunInformationTable
{

  public:
    enum { tNotFound = -1 };

  private:
    TRunInformationList theRunInformationList;

  public:
    TRunInformationTable();
    TRunInformationTable( const TRunInformationList& infolist );
    TRunInformationTable( const TRunInformationTable& right );
    ~TRunInformationTable();

  public:
    const TRunInformationTable& operator=( const TRunInformationTable& right );
    Tbool operator==( const TRunInformationTable& right ) const;
    Tbool operator!=( const TRunInformationTable& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TRunInformationTable& right );
    friend TOutputHtmlFileStream& operator<<( TOutputHtmlFileStream& html, const TRunInformationTable& right );
    friend TRunInformationTable operator+( const TRunInformationList& left, const TRunInformationTable& right );
    friend TRunInformationTable operator+( const TRunInformation& left, const TRunInformationTable& right );

  public:
    TRunInformationTable operator+( const TRunInformationTable& right ) const;
    TRunInformationTable operator+( const TRunInformationList& right ) const;
    TRunInformationTable operator+( const TRunInformation& right ) const;
    TRunInformationTable& operator+=( const TRunInformationTable& right );
    TRunInformationTable& operator+=( const TRunInformationList& right );
    TRunInformationTable& operator+=( const TRunInformation& right );

  public:
    const TRunInformationList& GetRunInformationList() const;
    TRunInformationList& GetRunInformationList();
    Tvoid SetRunInformationList( const TRunInformationList& infolist );

  public:
    Tint GetNumberOfRows() const;
    Tvoid SetRunInformation( const Tstring& item );
    Tvoid SetRunInformation( const Tstring& item, const Tstring& value );
    Tvoid SetRunInformation( const TRunInformation& runinfo );
    Tvoid SetRunInformation();
    Tvoid AddRunInformation( const Tstring& item );
    Tvoid AddRunInformation( const Tstring& item, const Tstring& value );
    Tvoid AddRunInformation( const TRunInformation& runinfo );
    Tvoid AddRunInformation();
    Tstring GetItem( const Tstring& value ) const;
    Tstring GetItem( Tint nrow ) const;
    Tstring GetValue( const Tstring& item ) const;
    Tstring GetValue( Tint nrow ) const;
    Tint FindItem( const Tstring& item ) const;
    Tint FindValue( const Tstring& value ) const;
    Tint FindRunInformation( const TRunInformation& runinfo ) const;
    Tbool HasItem( const Tstring& item ) const;
    Tbool HasRunInformation( const TRunInformation& runinfo ) const;
    Tvoid Remove( const Tstring& item );
    Tvoid Remove( const TRunInformation& runinfo );
    Tvoid Clear();

};

inline const TRunInformationList& TRunInformationTable::GetRunInformationList() const
{
  return( theRunInformationList );
}

inline TRunInformationList& TRunInformationTable::GetRunInformationList()
{
  return( theRunInformationList );
}

inline Tvoid TRunInformationTable::SetRunInformationList( const TRunInformationList& infolist )
{
  theRunInformationList = infolist;
  return;
}

#endif
