// =====================================================================
//  $Id: TBenchmark.cc,v 1.3 2003/07/30 18:26:40 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: TBenchmark.cc,v $
//  Revision 1.3  2003/07/30 18:26:40  goiwai
//  operator<<()νϤäѹޤ.
//
//  Revision 1.2  2003/07/30 16:21:20  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TBenchmark.hh"

TBenchmark::TBenchmark( const Tstring& unit )
  : theSystemTimer( unit ), theSystemClock(), theStartTime(), theStopTime()
{;}

TBenchmark::~TBenchmark()
{;}

Tvoid TBenchmark::Start()
{
  theSystemTimer.Start();
  theStartTime = theSystemClock.WhatTimeIsItNow();
  return;
}

Tvoid TBenchmark::Pause()
{
  theSystemTimer.Pause();
  theSystemTimer.Lap();
  return;
}

Tvoid TBenchmark::Restart()
{
  theSystemTimer.Restart();
  return;
}

Tvoid TBenchmark::Stop()
{
  theSystemTimer.Stop();
  theStopTime = theSystemClock.WhatTimeIsItNow();
  return;
}

Tvoid TBenchmark::Lap()
{
  theSystemTimer.Lap();
  return;
}

Tvoid TBenchmark::Continue()
{
  theSystemTimer.Lap();
  return;
}

Tvoid TBenchmark::PrintResult()
{
  Tcout << *this << Tendl;
  return;
}

Tostream& operator<<( Tostream& tos, const TBenchmark& right )
{
  tos << "Start: " << right.theStartTime << Tendl;
  tos << "Stop:  " << right.theStopTime << Tendl;
  tos << right.theSystemTimer << Tflush;
  return( tos );
}
