// =====================================================================
//  $Id: TOutputHtmlFileStream.cc,v 1.4 2003/07/30 16:21:21 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: TOutputHtmlFileStream.cc,v $
//  Revision 1.4  2003/07/30 16:21:21  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TOutputHtmlFileStream.hh"
#include "TSystemClock.hh"

static const Tstring _title = "UNTITLED DOCUMENT";

TOutputHtmlFileStream::TOutputHtmlFileStream()
  : Tofstream(), theStatus( 0 ), theTitle( _title ), theFileName( "" )
{;}

TOutputHtmlFileStream::TOutputHtmlFileStream( const Tstring& filename )
  : Tofstream( filename.c_str() ), theStatus( 0 ), theTitle( _title ), theFileName( filename )
{
  setStatusBit( TOutputHtmlFileStream::fopen );
  clearStatusBit( TOutputHtmlFileStream::fclose );
}

TOutputHtmlFileStream::TOutputHtmlFileStream( const Tstring& filename, const Tstring& title )
  : Tofstream( filename.c_str() ), theStatus( 0 ), theTitle( title ), theFileName( filename )
{
  setStatusBit( TOutputHtmlFileStream::fopen );
  clearStatusBit( TOutputHtmlFileStream::fclose );
  setStatusBit( TOutputHtmlFileStream::title );
}

TOutputHtmlFileStream::~TOutputHtmlFileStream()
{
  Close();
}

TOutputHtmlFileStream& TOutputHtmlFileStream::WriteHeader()
{
  if ( IsOpen() && !IsWrittenHeader() ) {
    *this << "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">" << Tendl;
    *this << "<html>" << Tendl;
    *this << "<head>" << Tendl;
    *this << "<title>" << theTitle << "</title>" << Tendl;
    *this << "<meta http-equiv=\"content-type\" content=\"text/html; charset=euc-jp\">" << Tendl;
    *this << "</head>" << Tendl;
    *this << "<body>" << Tendl;
    *this << "<h1>" << theTitle << "</h1>" << Tendl;
    *this << "<hr>" << Tendl;
    setStatusBit( TOutputHtmlFileStream::wheader );
  }
  return( *this );
}

TOutputHtmlFileStream& TOutputHtmlFileStream::WriteFooter()
{
  if ( IsOpen() && !IsWrittenFooter() ) {  
    TSystemClock clock;
    *this << "<hr>" << Tendl;
    *this << clock.WhatTimeIsItNow() << "<br>" << Tendl;
    *this << "$Id: TOutputHtmlFileStream.cc,v 1.4 2003/07/30 16:21:21 goiwai Exp $" << "<br>" << Tendl;
    *this << "$Name: CLDAQ-1-08-02 $" << "<br>" << Tendl;
    *this << "<hr>" << Tendl;
    *this << "<div align=right>" << Tendl;
    *this << "<address>" << Tendl;
    *this << "<a href=\"http://cldaq.sourceforge.jp/\">CLDAQ</a>, <a href=\"http://www.hep.sc.niigata-u.ac.jp/~iwai/\">Go IWAI</a>, <a href=\"mailto:iwai@hep.sc.niigata-u.ac.jp\">iwai@hep.sc.niigata-u.ac.jp</a>" << Tendl;
    *this << "</address>" << Tendl;
    *this << "</div>" << Tendl;
    *this << "</body>" << Tendl;
    *this << "</html>" << Tendl;
    setStatusBit( TOutputHtmlFileStream::wfooter );
  }
  return( *this );
}

TOutputHtmlFileStream& TOutputHtmlFileStream::OpenTable()
{
  if ( IsOpen() ) {
    if ( IsWrittenHeader() ) {
      if ( IsCloseTable() ) {
        *this << "<table border=1 cellpadding=4 width=\"100%\">" << Tendl;
      } else {
        CloseTable();
        *this << "<table border=1 cellpadding=4 width=\"100%\">" << Tendl;
      }
      setStatusBit( TOutputHtmlFileStream::otable );
      clearStatusBit( TOutputHtmlFileStream::ctable );
    } else {
      WriteHeader();
      OpenTable();
    }
  }
  return( *this );
}

TOutputHtmlFileStream& TOutputHtmlFileStream::CloseTable()
{
  if ( IsOpen() ) {
    if ( IsWrittenHeader() ) {
      if ( IsOpenTable() && !IsCloseTable() ) {
        *this << "</table>" << Tendl;
        *this << "<p>" << Tendl;
        clearStatusBit( TOutputHtmlFileStream::otable );
        setStatusBit( TOutputHtmlFileStream::ctable );
      }
    } else {
      WriteHeader();
    }
  }
  return( *this );
}

Tvoid TOutputHtmlFileStream::Open( const Tstring& filename )
{
  theFileName = filename;
  clearStatusBit( TOutputHtmlFileStream::wheader );
  clearStatusBit( TOutputHtmlFileStream::wfooter );
  clearStatusBit( TOutputHtmlFileStream::otable );
  setStatusBit( TOutputHtmlFileStream::ctable );
  if ( !IsOpen() ) {
    open( filename.c_str() );
    setStatusBit( TOutputHtmlFileStream::fopen );
    clearStatusBit( TOutputHtmlFileStream::fclose );
  }
  return;
}

Tvoid TOutputHtmlFileStream::Open( const Tstring& filename, const Tstring& title )
{
  SetTitle( title );
  Open( filename );
  return;
}

Tvoid TOutputHtmlFileStream::Close()
{
  if ( IsOpen() ) {
    if ( IsWrittenHeader() ) {
      if ( IsOpenTable() && !IsCloseTable() ) {
        CloseTable();
      }
      if ( !IsWrittenFooter() ) {
        WriteFooter();
      }
    }
    close();
    clearStatusBit( TOutputHtmlFileStream::fopen );
    setStatusBit( TOutputHtmlFileStream::fclose );

    clearStatusBit( TOutputHtmlFileStream::otable );
    setStatusBit( TOutputHtmlFileStream::ctable );
    clearStatusBit( TOutputHtmlFileStream::wheader );
    clearStatusBit( TOutputHtmlFileStream::wfooter );
  }
  return;
}
