// =====================================================================
//  $Id: Ttypes.h,v 1.12 2003/09/19 03:21:54 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: Ttypes.h,v $
//  Revision 1.12  2003/09/19 03:21:54  goiwai
//  2003ǯ7˹Ԥʤ줿ӡƥȤβϤĤΤ,С
//  夲ޤ.
//
//  Revision 1.11  2003/09/09 22:21:44  goiwai
//  С1.8.1ѹޤ.
//
//  Revision 1.10  2003/09/07 02:43:15  goiwai
//  ŻζڤȤȤ˥С򹹿ޤ.
//  1.7.1 -> 1.8.0
//
//  Revision 1.9  2003/08/17 02:02:53  goiwai
//  std::multimap  std::pair 򤽤줾 Tmultimap, Tpair  typedef 
//  .
//  n2Υơ֥ݤǤ.
//  ٥ꥹȤȻƤޤ,ɤǤ򻲾ȤǤ,
//  ͥƤ,䤹Ǥ.
//  դս,ȤݤȤȤǤ.Ȥ,
//    Map::iterator itr = map.find( "KEY" );
//    if ( itr ) {
//      itr -> second; // 
//      itr -> first;  // 
//    }
//  Ȥääˤʤޤ.
//
//  Revision 1.8  2003/08/17 00:55:50  goiwai
//  STL  std::map  TmapȤ typedef ޤ.
//
//  Revision 1.7  2003/08/05 23:05:00  goiwai
//  С1.7.1ˤ뤿Tversionͤѹޤ.
//
//  Revision 1.6  2003/07/30 18:31:09  goiwai
//  С1.7.0Ȥޤ.
//  ޤǤΤΤ CLDAQ-1-07-00 Ȥƥޤ.
//
//  Revision 1.5  2003/07/30 16:21:22  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TTYPES_HH
#define __TTYPES_HH

#include <iostream.h>
#include <iomanip.h>
#include <fstream.h>
#include <stdio.h>
#include <string>
#include <list>
#include <vector>
#include <map>
#include <strstream.h>

#define Tfalse 0
#define Ttrue 1
#define Tstd std
#define Tios Tstd::ios
#define Tin Tios::inin
#define Tout Tios::out
#define Tate Tios::ate
#define Tapp Tios::app
#define Ttrunc Tios::trunc
#define Tnocreate Tios::nocreate
#define Tnoreplace Tios::noreplace
#define Tbin Tios::bin
#define Tbinary Tios::binary
#define Tgoodbit Tios::goodbit
#define Teofbit Tios::eofbit
#define Tfailbit Tios::failbit
#define Tbadbit Tios::badbit
#define Tostream Tstd::ostream
#define Tostrstream Tstd::ostrstream
#define Tistream Tstd::istream
#define Tlist Tstd::list
#define Tvector Tstd::vector
#define Tmap Tstd::map
#define Tmultimap Tstd::multimap
#define Tpair Tstd::pair
#define Tcout Tstd::cout
#define Tcin Tstd::cin
#define Tcerr Tstd::cerr
#define Tendl Tstd::endl
#define Tends Tstd::ends
#define Tdec Tstd::dec
#define Thex Tstd::hex
#define Toct Tstd::oct
#define Tflush Tstd::flush
#define Tsizeof(_type_) sizeof(_type_)

typedef double Tdouble;
typedef int Tint;
typedef float Tfloat;
typedef char Tchar;
typedef long Tlong;
typedef unsigned char TUchar;
typedef unsigned int TUint;
typedef unsigned long TUlong;
typedef short Tshort;
typedef unsigned short TUshort;
typedef bool Tbool;
typedef Tbool Tbit;
typedef FILE TFileStream;
typedef size_t Tsize_t;
typedef pid_t Tpid_t;
typedef time_t Ttime_t;
typedef socklen_t Tsocklen_t;
typedef caddr_t Tcaddr_t;
typedef off_t Toff_t;
typedef pthread_t Tthread_t;
typedef clock_t Tclock_t;
typedef void Tvoid;
typedef Tstd::string Tstring;
typedef Tstd::ofstream Tofstream;
typedef Tstd::ifstream Tifstream;
typedef Tvector<Tint> TintList;
typedef Tvector<TUint> TUintList;
typedef Tvector<TUshort> TUshortList;
typedef Tvector<Tdouble> TdoubleList;
typedef Tvector<Tfloat> TfloatList;
typedef Tvector<Tstring> TstringList;
#ifdef __CLDAQ_ZLIB_USE
typedef z_stream Tzstream;
typedef Byte Tbyte;
#endif

static const Tstring Tspace = " ";
static const Tstring Thyphen = "-";
static const Tstring Tslash = "/";
static const Tstring Twslash = Tslash + Tslash;
static const Tstring Twquote = "\"";
static const Tstring Tquote = "'";
static const Tstring Tsharp = "#";
static const Tstring Tpipe = "|";
static const Tstring Tcolon = ":";
static const Tstring Twspace = Tspace + Tspace;
static const Tstring Ttab = "\t";
static const Tstring Tbeep = "\b";
static const Tstring Thour = "h";
static const Tstring Tmin = "m";
static const Tstring Tsec = "s";
static const Tstring Tmsec = "ms";
static const Tstring Tusec = "us";
static const Tstring Tnsec = "ns";
static const Tstring Tid = "$Id: Ttypes.h,v 1.12 2003/09/19 03:21:54 goiwai Exp $";
static const Tstring Tname = "$Name: CLDAQ-1-08-02 $";
static const Tstring Tproject = "CLDAQ";
static const Tstring Tversion = "1.8.2";
static const Tstring Texit = "exit";
static const Tstring Tprompt = Tproject + Thyphen + Tversion + ">" + Tspace;
static const Tchar Tkey = '\x01';
static const Tchar Teol = '\n';

enum Tobject_t { 
  tObjectDataRecord,
  tObjectDataSection,
  tObjectDataSegment,
  tObjectDataElement,
  tObject1DHistogram,
  tObject2DHistogram,
  tObjectAppendGraph,
  tObjectSubstituteGraph,
  tObjectNtuple,
  tNumberOfObjectTypes,
  tObjectUnknown = -1
};

enum Telement_t {
  tTypeInt,
  tTypeString,
  tTypeDouble,
  tTypeObject,
  tTypeFloat,
  tTypeUnsignedShort,
  tTypeShort,
  tTypeWord,
  tTypeLong,
  tTypeUnsignedLong,
  tTypeUnsignedInt,
  tNumberOfElementTypes,
  tTypeUnknown = -1
};

enum Tstream_t { 
  tFileStream,
  tSocketStream,
  tSharedMemoryStream,
  tNumberOfStreamTypes,
  tUnknownStream = -1
};

enum Trandom_t {
  tRandomExponential,
  tRandomGaussian,
  tRandomChiSquare,
  tRandomLandau,
  tRandomGamma,
  tRandomPoisson,
  tNumberOfRandomTypes,
  tRandomUnknown = -1
};

enum Tstatus_t {
  tStatusStandby,
  tStatusReady,
  tStatusBusy,
  tStatusIdle,
  tStatusWaitingReady,
  tStatusJustTakingEvent,
  tStatusJustRecordingEvent,
  tStatusSleep,
  tStatusDead,
  tNumberOfStatusTypes,
  tStatusUnknown = -1
};

enum TvmeTransfer_t {
  tA16D16,
  tA16D32,
  tA24D16,
  tA24D32,
  tA32D16,
  tA32D32,
  tA24D16dma,
  tA32D16dma,
  tA24D32dma,
  tA32D32dma, 
  tNumberOfVmeTransferModes,
  tTransferModeUnknown = -1
};

// with Sanshiro driver
static const Tstring TvmeDevices[ tNumberOfVmeTransferModes ] =
{
  "/dev/vmedrv16d16",
  "/dev/vmedrv16d32",
  "/dev/vmedrv24d16",
  "/dev/vmedrv24d32",
  "/dev/vmedrv32d16",
  "/dev/vmedrv32d32",
  "/dev/vmedrv24d16dma",
  "/dev/vmedrv32d16dma",
  "/dev/vmedrv24d32dma",
  "/dev/vmedrv32d32dma"
};

enum TcamacCrateController_t {
  tISAcc7000_1,
  tISAcc7000_2,
  tISAcc7000_3,
  tISAcc7000_4,
  tISAcc7700_1,
  tISAcc7700_2,
  tISAcc7700_3,
  tISAcc7700_4, 
  tPCIcc7700_1,
  tPCIcc7700_2,
  tPCIcc7700_3,
  tPCIcc7700_4,
  tNumberOfCamacCrateController,
  tCamacCrateControllerUnknown = -1
};

// with Yasu driver
static const Tstring TcamacDevices[ tNumberOfCamacCrateController ] =
{
  "/dev/ISAcc7000.1",
  "/dev/ISAcc7000.2",
  "/dev/ISAcc7000.3",
  "/dev/ISAcc7000.4",
  "/dev/ISAcc7700.1",
  "/dev/ISAcc7700.2",
  "/dev/ISAcc7700.3",
  "/dev/ISAcc7700.4",
  "/dev/PCIcc7700.1",
  "/dev/PCIcc7700.2",
  "/dev/PCIcc7700.3",
  "/dev/PCIcc7700.4"
};

enum Truninfo_t { 
  tInfoFreeValue,
  tInfoSelectableValue,
  tInfoFreeText,
  tNumberOfInformations,
  tInfoUnknown = -1
};

enum { 
  tIDunknown = -1
};

static const Tstring TunknownID = "unkown ID";

#endif
