// =====================================================================
//  $Id: ifiledump.cc,v 1.2 2003/07/30 16:21:38 goiwai Exp $
//  $Name: CLDAQ-1-08-02 $
//
//  $Log: ifiledump.cc,v $
//  Revision 1.2  2003/07/30 16:21:38  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TInputObjectFile.hh"
#include "TBenchmark.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return( -1 );
  }
  const Tstring filename = argv[ 1 ];

  TInputObjectFile ifile( filename );
  Tint nevents = 0;
  Tint datasize = 0;

  TDataRecord record;
  TBenchmark bench;
  bench.Start();
  while ( ( ifile >> record ) != 0 ) {
    Tcout << record << Tendl;
    datasize += record.GetRecordSize();
    nevents ++;
  }
  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << ifile.GetTotalDataSize();
  Tcout << " byte data has been read from " << filename << "." << Tendl;

  return( 0 );
}
