// =====================================================================
//  $Id: rs01OFFvdcview16.cc,v 1.2 2003/10/06 16:28:15 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: rs01OFFvdcview16.cc,v $
//  Revision 1.2  2003/10/06 16:28:15  goiwai
//  *** empty log message ***
//
//  Revision 1.1  2003/09/17 09:40:05  goiwai
//  ڥǥθʤɤ߽ФŰ(V) VS (H:M:S)ͥ16(
//  )ˤĤƤΤߥץåȤޤ.
//
//
// =====================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TEnvironmentVariableTable.hh"
#include "TInputObjectFile.hh"
#include "Trootinit.h"

static const Tstring rcpath = "rs01setup";
static const Tint npin = 32;
// static Tint pinpos[ npin ] = {
//            3,  4, 5,   6,  7,
//       10, 11, 12, 13, 14, 15, 16,
//   17, 18, 19, 20, 21, 22, 23, 24,
//       26, 27, 28, 29, 30, 31, 32,
//           35, 36, 37, 38, 39
// };

TInputObjectFile* ifile = 0;
TEnvironmentVariableTable* envtable = 0;
TDataRecord record;
TDataElement element;
Tdouble vdc[ npin ];
Tint elapsed[ npin ];
//
TApplication* theApplication = 0;
TCanvas* CVvdc = 0;
static const Tint nx = 8;
static const Tint ny = 5;
static const Tint npadvdc = nx * ny;
TH1D** H1Dvdc;

Tstring htvdc[ npin ];
Tstring hnamevdc[ npin ];
Tstring fpath, macrof, giff, psf, rootf;
static Tbool autoprint, enableoverwrite;
static Tint modperiod;

static Tvoid initialize( Tint argc, Tchar** argv );
static Tvoid event();
static Tvoid runbegin();
static Tvoid runend();

int main( int argc, char** argv, char** envv )
{
  initialize( argc, argv );

  while ( ifile -> Read( record ) ) {
    Tstring recid = record.GetID();
    if ( recid == "RUN BEGIN" ) {
      runbegin();
      continue;
    } else if ( recid == "EVENT" ) {
      event();
    } else if ( recid == "RUN END" ) {
      runend();
      break;
    } else {
      Tcerr << "unknown tag: " << recid << Tendl;
      break;
    }
    gSystem -> ProcessEvents();
  }

  theApplication -> Terminate();
  return 0;
}

Tvoid initialize( Tint argc, Tchar** argv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <run#>" << Tendl;
    exit( -1 );
  }

  Tint runid = (Tint)strtol( argv[ 1 ], 0, 0 );
  Tstring runidstr = itostr( runid );

  envtable = new TEnvironmentVariableTable ( rcpath );
  Tstring rechead = envtable -> GetEnvironmentValue( "RS01_RECORD_HEAD" );
  Tstring recpath = envtable -> GetEnvironmentValue( "RS01_RECORD_DIR" );
  fpath = recpath + Tslash + rechead + runidstr + ".drec";
  ifile = new TInputObjectFile( fpath );

  //Tstring rootdir = envtable -> GetEnvironmentValue( "RS01_ROOTFILE_DIR" );
  rootf = rechead + runidstr + "vdc16.root";
  //Tstring macrodir = envtable -> GetEnvironmentValue( "RS01_ROOTFILE_DIR" );
  macrof = rechead + runidstr + "vdc16.C";
  //Tstring gifdir = envtable -> GetEnvironmentValue( "RS01_FIGURE_DIR" );
  giff = rechead + runidstr + "vdc16.gif";
  //Tstring psdir = envtable -> GetEnvironmentValue( "RS01_FIGURE_DIR" );
  psf = rechead + runidstr + "vdc16.ps";

  modperiod = envtable -> GetIntegerValue( "RS01_UPDATE_PERIOD" );
  enableoverwrite = (Tbool)envtable -> GetIntegerValue( "RS01_OVERWRITE_ENABLE" );
  autoprint = (Tbool)envtable -> GetIntegerValue( "RS01_AUTO_PRINT" );



  theApplication = rootinit();
  TGaxis::SetMaxDigits( 2 );


  // Ű VS  Х
  CVvdc = new TCanvas( "CVvdc", "VDC VS Time" );
  CVvdc -> ToggleEventStatus();


  // Ű VS ֤ν
  H1Dvdc = new TH1D*[npin];
  for ( Tint ch = 0; ch < npin; ch ++ ) {
    htvdc[ ch ] = "Channel: " + itostr( ch, 2 ) + ", Run ID: " + runidstr;
    hnamevdc[ ch ] = "H1Dvdc" + itostr( ch, 2 );

    H1Dvdc[ ch ] = 
      new TH1D( hnamevdc[ ch ].c_str(), htvdc[ ch ].c_str(), 10, 0.0, 10.0 );

    H1Dvdc[ ch ] -> SetStats( 0 );
    H1Dvdc[ ch ] -> GetXaxis() -> SetTimeDisplay( 1 );
    H1Dvdc[ ch ] -> SetMarkerStyle( 1 );
    H1Dvdc[ ch ] -> SetLineColor( 10 );
    H1Dvdc[ ch ] -> SetLineStyle( 0 );
    H1Dvdc[ ch ] -> SetLineWidth( 0 );
    
    H1Dvdc[ ch ] -> GetXaxis() -> SetNdivisions( 504 );
    H1Dvdc[ ch ] -> GetXaxis() -> SetTimeFormat( "%H:%M:%S" );
    H1Dvdc[ ch ] -> GetXaxis() -> SetTitle( "Time (H:M:S)" );
    H1Dvdc[ ch ] -> GetXaxis() -> CenterTitle();

    H1Dvdc[ ch ] -> GetYaxis() -> SetTitle( "DC Voltage (V)" );
    H1Dvdc[ ch ] -> GetYaxis() -> SetNoExponent();
    H1Dvdc[ ch ] -> GetYaxis() -> CenterTitle();
  }

  //ɽΤ ch16 Τ
  CVvdc -> cd();
  H1Dvdc[ 16 ] -> Draw( "pe" );

  return;
}

Tvoid event()
{
  for ( Tint ch = 0; ch < npin; ch ++ ) {
    // VDCΥʥåץå
    element = record[ 1 ][ ch ][ 0 ];
    element.StorePrimitives( &vdc[ ch ] );

    // 󳫻Ϥηвÿ(sec)
    element = record[ 1 ][ ch ][ 3 ];
    element.StorePrimitives( &elapsed[ ch ] );

    //Ű VS 
    H1Dvdc[ ch ] -> SetBinContent( elapsed[ ch ], vdc[ ch ] );

    H1Dvdc[ ch ] -> GetXaxis() -> SetNdivisions( 504 );
    H1Dvdc[ ch ] -> GetXaxis() -> SetTimeFormat( "%H:%M:%S" );
    H1Dvdc[ ch ] -> GetXaxis() -> SetTitle( "Time (H:M:S)" );
    H1Dvdc[ ch ] -> GetXaxis() -> CenterTitle();
    H1Dvdc[ ch ] -> GetYaxis() -> SetTitle( "DC Voltage (V)" );
    H1Dvdc[ ch ] -> GetYaxis() -> SetNoExponent();
    H1Dvdc[ ch ] -> GetYaxis() -> CenterTitle();

    H1Dvdc[ ch ] -> SetDrawOption( "pe" );
  }



  // update
  element = record[ 0 ][ 0 ][ 0 ];
  Tint eventid;
  element.StorePrimitives( &eventid );
  if ( eventid % modperiod == 0 ) {
    CVvdc->Modified();
    CVvdc->Update();
  }

  return;
}

Tvoid runbegin()
{
  element = record[ 0 ][ 1 ][ 1 ];
  Tint secbuf;
  element.StorePrimitives( &secbuf );
  gStyle -> SetTimeOffset( secbuf );
  return;
}

Tvoid runend()
{
  // update
  CVvdc->Modified();
  CVvdc->Update();

  // printout
  CVvdc -> cd();

  TFile* file = new TFile( rootf.c_str(), "RECREATE", "VDC VIEW OFFLINE" );
  H1Dvdc[ 16 ] -> Write();
  CVvdc -> Write();
  file -> Close();


  CVvdc -> Print( giff.c_str() );
  CVvdc -> Print( psf.c_str() );

  return;
}
