// =====================================================================
//  $Id: OFFdarkaverage.cc,v 1.3 2003/10/06 16:28:17 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: OFFdarkaverage.cc,v $
//  Revision 1.3  2003/10/06 16:28:17  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:15:51  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include <TROOT.h>
#include <TSystem.h>
#include <TApplication.h> 
#include <TStyle.h>
#include <TGraph.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TNtuple.h>
#include <TFile.h>
#include <TPad.h>

#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"
#include "St00OfflineDarkAverageMap.hh"
#include "St00OfflineRmsMap.hh"
#include "St00SinglePixelInterface.hh"
#include "St00SinglePixelList.hh"
#include "St00DataRecordConversion.hh"
#include "St00BadChannelMap.hh"
#include "TDataMultiplicity.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 4 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <dark> <temp> <T>" << Tendl;
    return -1;
  }

  St00BadChannelMap badmap( argv[ 1 ] );
  const St00OfflineRmsMap& rmsmap = badmap.GetOfflineRmsMap();
  const St00OfflineDarkAverageMap& avemap = rmsmap.GetOfflineDarkAverageMap();


  Tint npixel = 0;
  const TDataMultiplicity& ave = avemap.GetMap();
  //const TDataMultiplicity& rms = rmsmap.GetMap();

  Tdouble sum = 0.0;

  for ( Tint row = 0; row < ave.num_row(); row ++ ) {
    for ( Tint col = 0; col < ave.num_col(); col ++ ) {
      if ( badmap.IsGoodChannel( row, col ) ) {
	sum += ave[ row ][ col ];
	npixel ++;
      }
    }
  }

  sum /= (Tdouble)npixel;
  Tdouble temp = strtod( argv[ 2 ], 0 );
  Tdouble T = strtod( argv[ 3 ], 0 );
  Tcout << temp << " " << T << " " << sum << Tendl;



  return 0;
}
