// =====================================================================
//  $Id: St00SinglePixel.cc,v 1.3 2003/10/06 16:28:17 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: St00SinglePixel.cc,v $
//  Revision 1.3  2003/10/06 16:28:17  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:15:52  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "St00SinglePixel.hh"

St00SinglePixel::St00SinglePixel( Tint h, Tint v, Tdouble signal, Tdouble dark, Tdouble rms )
  : theHorizontalID( h ), theVerticalID( v ),
    theSignal( signal ), theDark( dark ), theRms( rms )
{;}

St00SinglePixel::St00SinglePixel( const St00SinglePixel& right )
  : theHorizontalID( right.theHorizontalID ),
    theVerticalID( right.theVerticalID ),
    theSignal( right.theSignal ),
    theDark( right.theDark ),
    theRms( right.theRms )
{;}

St00SinglePixel::~St00SinglePixel()
{;}

const St00SinglePixel& St00SinglePixel::operator=( const St00SinglePixel& right )
{
  theHorizontalID = right.theHorizontalID;
  theVerticalID = right.theVerticalID;
  theSignal = right.theSignal;
  theDark = right.theDark;
  theRms = right.theRms;
  return *this;
}

Tbool St00SinglePixel::operator==( const St00SinglePixel& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( theHorizontalID == right.theHorizontalID );
  retval &= ( theVerticalID == right.theVerticalID );
  retval &= ( theSignal == right.theSignal );
  retval &= ( theDark == right.theDark );
  retval &= ( theRms == right.theRms );
  return retval;
}

Tbool St00SinglePixel::operator!=( const St00SinglePixel& right ) const
{
  Tbool retval = Tfalse;
  retval |= ( theHorizontalID != right.theHorizontalID );
  retval |= ( theVerticalID != right.theVerticalID );
  retval |= ( theSignal != right.theSignal );
  retval |= ( theDark != right.theDark );
  retval |= ( theRms != right.theRms );
  return retval;
}

Tostream& operator<<( Tostream& tos, const St00SinglePixel& right )
{
  tos << right.theHorizontalID << Tspace;
  tos << right.theVerticalID << Tspace;
  tos << right.theSignal << Tspace;
  tos << right.theDark << Tspace;
  tos << right.theRms << Tflush;
  return tos;
}

Tistream& operator>>( Tistream& tis, St00SinglePixel& right )
{
  return tis >> right.theHorizontalID >> right.theVerticalID >> right.theSignal >> right.theDark >> right.theRms;
}
