// =====================================================================
//  $Id: St01RunAction.hh,v 1.3 2003/10/06 16:28:18 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: St01RunAction.hh,v $
//  Revision 1.3  2003/10/06 16:28:18  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:16:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __ST01RUNACTION_HH
#define __ST01RUNACTION_HH

#include "TRunAction.hh"
#include "TOutputHtmlFileStream.hh"

class TRun;
class TOutputObjectFile;
class TInputObjectFile;
class TDataRecord;
class St01RunSummary;

class St01RunAction
  : public TRunAction
{

  private:
    TOutputObjectFile* theOutputFile;
    St01RunSummary* theRunSummary;
    TOutputHtmlFileStream theOutputHtml;

  public:
    St01RunAction();
    ~St01RunAction();

  public:
    Tvoid BeginOfRunAction( TRun& aRun );
    Tvoid EndOfRunAction( TRun& aRun );
    Tvoid FinalOfRunAction( TRun& aRun );

  public:
    TOutputObjectFile* GetOutputFile() const;
    St01RunSummary* GetRunSummary() const;
    TOutputHtmlFileStream& GetOutputHtml();

  private:
    Tvoid fillRunBeginInformation( const TDataRecord& record );
    Tvoid fillRunEndInformation( const TDataRecord& record );
    Tvoid setFileName( Tint runid, Tstring& drecfile, Tstring& htmlfile );

};

inline TOutputObjectFile* St01RunAction::GetOutputFile() const
{
  return theOutputFile;
}

inline St01RunSummary* St01RunAction::GetRunSummary() const
{
  return theRunSummary;
}

inline TOutputHtmlFileStream& St01RunAction::GetOutputHtml()
{
  return theOutputHtml;
}

#endif
