// =====================================================================
/*!
//
//  \file TDataRecord.hh
//  \brief This file contains the TDataRecord class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TDataRecord.hh,v 1.5 2003/11/03 08:35:12 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TDataRecord.hh,v $
//  Revision 1.5  2003/11/03 08:35:12  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.4  2003/10/06 16:42:08  goiwai
//  ƥѤδؿȤTest()äޤ.Ŭʥǡ쥳ɤȯ
//  .
//
//  Revision 1.3  2003/08/25 09:19:37  goiwai
//  operator[]( const Tstring& id ) äޤ.
//  record[0] Ȥ record["tag"] Ȥ,TDataSection 뤳Ȥ
//  ޤ.
//  size()ۤϰϤˤ,åʤǥޤ.
//  ޥåʤäޤ.
//  Ʊ̾ǥ줿 DataSection ,ǽ˥ޥåΤ֤
//  Ƥޤ.
//
//  Revision 1.2  2003/07/30 16:17:51  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TDATARECORD_HH
#define __TDATARECORD_HH

#include "Tglobals.h"
#include "TStreamableObject.hh"
#include "TDataSectionList.hh"

class TOutputObjectStream;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TDataRecord
// \brief This is the TDataRecord class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TDataRecord class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup DatarecordCategory
*/
class TDataRecord
  : public TStreamableObject, public TDataSectionList
{

  public:
    TDataRecord( const Tstring& id = TunknownID );
    TDataRecord( const TDataRecord& right );
    ~TDataRecord();

  public:
    Tint GetRecordSize();
    Tint Record( TOutputObjectStream* output );
    Tvoid Clear();
    Tint Serialize( Tvoid* buffer );

  public:
    const TDataRecord& operator=( const TDataRecord& right );
    Tbool operator==( const TDataRecord& right ) const;
    Tbool operator!=( const TDataRecord& right ) const;
    //operator[]( const Tstring& secid )ää
    //reference operator [](size_type n);
    //const_reference operator [](size_type n) const;
    //TDataSection& operator[]( Tsize_t n );
    //ʤߤ.ɤʡ
    const TDataSection& operator[]( Tint n ) const;
    TDataSection& operator[]( Tint n );
    const TDataSection& operator[]( const Tstring& id ) const;
    TDataSection& operator[]( const Tstring& id );
    friend Tostream& operator<<( Tostream& tos, const TDataRecord& right );

  public:
    TDataRecord Test( Tint somevalue = 0 );

  public:
    Tbool FindDataSection( const Tstring& id, TDataSection& section ) const;
    Tint FindDataSection( const Tstring& id ) const;
    Tbool FindDataSegment( const Tstring& secid, const Tstring& segid, TDataSegment& segment ) const;
    Tint FindDataSegment( const Tstring& secid, const Tstring& segid ) const;
    Tbool FindDataSegment( Tstring idset[ 2 ], TDataSegment& segment ) const;
    Tint FindDataSegment( Tstring idset[ 2 ] ) const;
    Tbool FindDataSegment( const TstringList& idset, TDataSegment& segment ) const;
    Tint FindDataSegment( const TstringList& idset ) const;
    Tbool FindDataElement( const Tstring& secid, const Tstring& segid, const Tstring& eleid, TDataElement& element ) const;
    Tint FindDataElement( const Tstring& secid, const Tstring& segid, const Tstring& eleid ) const;
    Tbool FindDataElement( Tstring idset[ 3 ], TDataElement& element ) const;
    Tint FindDataElement( Tstring idset[ 3 ] ) const;
    Tbool FindDataElement( const TstringList& idset, TDataElement& element ) const;
    Tint FindDataElement( const TstringList& idset ) const;

  private:
    Tint record( TOutputObjectFile* ofile );
    Tint record( TOutputObjectSocket* osocket );
    Tint record( TOutputObjectSharedMemory* omemory );

};

#endif
