// =====================================================================
//  $Id: TDataSection.cc,v 1.5 2003/10/06 16:42:19 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TDataSection.cc,v $
//  Revision 1.5  2003/10/06 16:42:19  goiwai
//  *** empty log message ***
//
//  Revision 1.4  2003/08/25 09:20:29  goiwai
//  operator[]( const Tstring& id ) äޤ.
//  record[0] Ȥ record["tag"] Ȥ, TDataSegment 뤳Ȥ
//  ޤ.
//  size()ۤϰϤˤ,åʤǥޤ.
//  ޥåʤäޤ.
//  Ʊ̾ǥ줿 DataSegment ,ǽ˥ޥåΤ֤
//  Ƥޤ.
//
//  Revision 1.3  2003/07/30 16:17:51  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataSection.hh"
#include "TOutputObjectStream.hh"
#include "TOutputObjectFile.hh"
#include "TOutputObjectSocket.hh"
#include "TOutputObjectSharedMemory.hh"


TDataSection::TDataSection( const Tstring& id )
  : TStreamableObject( tObjectDataSection, id ), TDataSegmentList()
{;}

TDataSection::TDataSection( const TDataSection& right )
  : TStreamableObject( right ), TDataSegmentList( right )
{;}

TDataSection::~TDataSection()
{;}

Tint TDataSection::GetRecordSize()
{
  Tsize_t nchar = theID.size() + 1;
  // record size + object type + object id + number of entries
  Tint total = Tsizeof( Tint ) + Tsizeof( Tobject_t ) + Tsizeof( Tsize_t ) + ( Tsizeof( Tchar ) * nchar ) + Tsizeof( Tsize_t );
  for ( Tsize_t i = 0; i < size(); i ++ ) {
    total += ( (*this)[ i ] ).GetRecordSize();
  }
  return total;
}

Tint TDataSection::Record( TOutputObjectStream* output )
{
  Tint datasize = 0;
  Tstream_t streamtype = output -> GetStreamType();

  switch ( streamtype ) {
    case tFileStream:
      datasize = record( (TOutputObjectFile*)output );
      break;
    case tSocketStream:
      datasize = record( (TOutputObjectSocket*)output );
      break;
    case tSharedMemoryStream:
      datasize = record( (TOutputObjectSharedMemory*)output );
      break;
    case tUnknownStream:
    default:
      Tcerr << "TDataSection::Record: unknown stream type." << Tendl;
      return 0;
  }

  for ( Tint i = 0; i < (Tint)size(); i ++ )
    datasize += ( (*this)[ i ] ).Record( output );

  return datasize;
}

Tostream& operator<<( Tostream& tos, const TDataSection& right )
{
  tos << "Data Section(" << right.theObjectType << "), "
      << "ID: " << right.theID
      << ", Capacity: " << right.capacity()
      << ", Entry: " << right.size();

  if ( right.empty() ) {
    return tos;
  }
  
  tos << Tendl;

  for ( Tsize_t i = 0; i < right.size(); i ++ ) {
    tos << Ttab << Ttab << "[" << i << "] " << right[ i ];
    if ( i != right.size() - 1 ) {
      tos << Tendl;
    }
  }

  return tos;
}

Tint TDataSection::record( TOutputObjectFile* ofile )
{
  Tsize_t datasize = 0;
  static const Tsize_t nmemb = 1;
  Tsize_t ss = 0;
  static const Tstring head = "TDataSection::record";


  // write record size
  Tint recsize = GetRecordSize();
  ss = fwrite( &recsize, Tsizeof( Tint ), nmemb, ofile -> GetFileStream() );
  if ( ss != nmemb ) {
    perror( head.c_str() );
  } else {
    datasize += ss * Tsizeof( Tint );
  }


  // write object type
  ss = fwrite( &theObjectType, Tsizeof( Tobject_t ), nmemb, ofile -> GetFileStream() );
  if ( ss != nmemb ) {
    perror( head.c_str() );
  } else {
    datasize += ss * Tsizeof( Tobject_t );
  }


  // write object ID
  Tchar charbuf;
  Tsize_t nchar = theID.size() + 1;
  ss = fwrite( &nchar, Tsizeof( Tsize_t ), nmemb, ofile -> GetFileStream() );
  if ( ss != nmemb ) {
    perror( head.c_str() );
  } else {
    datasize += ss * Tsizeof( Tsize_t );
  }
  for ( Tsize_t i = 0; i < nchar; i ++ ) {
    if ( i == ( nchar - 1 ) ) {
      charbuf = '\0';
    } else {
      charbuf = theID[ i ];
    }
    ss = fwrite( &charbuf, Tsizeof( Tchar ), nmemb, ofile -> GetFileStream() );
    if ( ss != nmemb ) {
      perror( head.c_str() );
    } else {
      datasize += ss * Tsizeof( Tchar );
    }
  }


  // write number of entries
  Tsize_t entry = size();
  ss = fwrite( &entry, Tsizeof( Tsize_t ), nmemb, ofile -> GetFileStream() );
  if ( ss != nmemb ) {
    perror( head.c_str() );
  } else {
    datasize += ss * Tsizeof( Tsize_t );
  }


  return (Tint)datasize;
}

Tint TDataSection::record( TOutputObjectSocket* osocket )
{
  Tsize_t datasize = 0;
  static const Tstring head = "TDataSection::record";


  // send record size
  Tint recsize = GetRecordSize();
  if ( send( osocket -> GetServerDescriptor(), &recsize, Tsizeof( Tint ), 0 ) != Tsizeof( Tint ) ) {
    perror( head.c_str() );
  } else {
    datasize += Tsizeof( Tint );
  }


  // send object type
  if ( send( osocket -> GetServerDescriptor(), &theObjectType, Tsizeof( Tobject_t ), 0 ) != Tsizeof( Tobject_t ) ) {
    perror( head.c_str() );
  } else {
    datasize += Tsizeof( Tobject_t );
  }


  // send object ID
  Tchar charbuf;
  Tsize_t nchar = theID.size() + 1;
  if ( send( osocket -> GetServerDescriptor(), &nchar, Tsizeof( Tsize_t ), 0 ) != Tsizeof( Tsize_t ) ) {
    perror( head.c_str() );
  } else {
    datasize += Tsizeof( Tsize_t );
  }
  for ( Tsize_t i = 0; i < nchar; i ++ ) {
    if ( i == ( nchar - 1 ) ) {
      charbuf = '\0';
    } else {
      charbuf = theID[ i ];
    }
    if ( send( osocket -> GetServerDescriptor(), &charbuf, Tsizeof( Tchar ), 0 ) != Tsizeof( Tchar ) ) {
      perror( head.c_str() );
    } else {
      datasize += Tsizeof( Tchar );
    }
  }


  // send number of entries
  Tsize_t entry = size();
  if ( send( osocket -> GetServerDescriptor(), &entry, Tsizeof( Tsize_t ), 0 ) != Tsizeof( Tsize_t ) ) {
    perror( head.c_str() );
  } else {
    datasize += Tsizeof( Tsize_t );
  }


  return (Tint)datasize;
}

Tint TDataSection::record( TOutputObjectSharedMemory* omemory )
{
  Tsize_t datasize = 0;
  Tvoid* ptr = omemory -> GetAddress();

  // write record size
  *( (Tint*)ptr ) = GetRecordSize();
  datasize += Tsizeof( Tint );
  ( (Tint*)ptr ) ++;


  // write object type
  *( (Tobject_t*)ptr ) = theObjectType;
  datasize += Tsizeof( Tobject_t );
  ( (Tobject_t*)ptr ) ++;


  // write object ID
  Tchar charbuf;
  Tsize_t nchar = theID.size() + 1;
  *( (Tsize_t*)ptr ) = nchar;
  datasize += Tsizeof( Tsize_t );
  ( (Tsize_t*)ptr ) ++;
  for ( Tsize_t i = 0; i < nchar; i ++ ) {
    if ( i == ( nchar - 1 ) ) {
      charbuf = '\0';
    } else {
      charbuf = theID[ i ];
    }
    *( (Tchar*)ptr ) = charbuf;
    datasize += Tsizeof( Tchar );
    ( (Tchar*)ptr ) ++;
  }


  // write number of entries
  Tsize_t entry = size();
  *( (Tsize_t*)ptr ) = entry;
  datasize += Tsizeof( Tsize_t );
  ( (Tsize_t*)ptr ) ++;


  omemory -> SetAddress( ptr );

  return (Tint)datasize;
}

const TDataSection& TDataSection::operator=( const TDataSection& right )
{
  *( (TStreamableObject*)this ) = *( (TStreamableObject*)(&right) );
  *( (TDataSegmentList*)this ) = *( (TDataSegmentList*)(&right) );

  return *this;
}

Tbool TDataSection::operator==( const TDataSection& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *((TStreamableObject*)this) == *((TStreamableObject*)(&right)) );
  ret &= ( *( (TDataSegmentList*)this ) == *( (TDataSegmentList*)(&right) ) );

  return ret;
}

Tbool TDataSection::operator!=( const TDataSection& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *((TStreamableObject*)this) != *((TStreamableObject*)(&right)) );
  ret |= ( *((TDataSegmentList*)this) != *((TDataSegmentList*)(&right)) );
  return ret;
}

Tvoid TDataSection::Clear()
{
  theID = TunknownID;
  for ( Tsize_t i = 0; i < size(); i ++ )
    ( (*this)[ i ] ).Clear();
  clear();
  return;
}

Tbool TDataSection::FindDataSegment( const Tstring& id, TDataSegment& segment ) const
{
  for ( Tsize_t i = 0; i < size(); i ++ ) {
    if ( ( (*this)[ i ] ).GetID() == id ) {
      segment = (*this)[ i ];
      return Ttrue;
    }
  }
  return Tfalse;
}

Tint TDataSection::FindDataSegment( const Tstring& id ) const
{
  Tint retval = -EFAULT;
  for ( Tsize_t i = 0; i < size(); i ++ ) {
    if ( ( (*this)[ i ] ).GetID() == id ) {
      retval = i;
      break;
    }
  }
  return retval;
}

Tbool TDataSection::FindDataElement( const Tstring& segid, const Tstring& eleid, TDataElement& element ) const
{
  TDataSegment segment;
  if ( FindDataSegment( segid, segment ) ) {
    return segment.FindDataElement( eleid, element );
  } else {
    return Tfalse;
  }
}

Tint TDataSection::FindDataElement( const Tstring& segid, const Tstring& eleid ) const
{
  Tint segpos = FindDataSegment( segid );
  if ( segpos >= 0 ) {
    return ( (*this)[ segpos ] ).FindDataElement( eleid );
  } else {
    return segpos;
  }
}

Tbool TDataSection::FindDataElement( Tstring idset[ 2 ], TDataElement& element ) const
{
  return FindDataElement( idset[ 0 ], idset[ 1 ], element );
}

Tint TDataSection::FindDataElement( Tstring idset[ 2 ] ) const
{
  return FindDataElement( idset[ 0 ], idset[ 1 ] );
}

Tbool TDataSection::FindDataElement( const TstringList& idset, TDataElement& element ) const
{
  return FindDataElement( idset[ 0 ], idset[ 1 ], element );
}

Tint TDataSection::FindDataElement( const TstringList& idset ) const
{
  return FindDataElement( idset[ 0 ], idset[ 1 ] );
}

Tint TDataSection::Serialize( Tvoid* buffer )
{
  Tsize_t datasize = 0;

  // write record size
  *( (Tint*)buffer ) = GetRecordSize();
  ( (Tint*)buffer ) ++;
  datasize += Tsizeof( Tint );


  // write object type
  *( (Tobject_t*)buffer ) = theObjectType;
  ( (Tobject_t*)buffer ) ++;
  datasize += Tsizeof( Tobject_t );


  // write object ID
  Tchar charbuf;
  Tsize_t nchar = theID.size() + 1;
  *( (Tsize_t*)buffer ) = nchar;
  ( (Tsize_t*)buffer ) ++;
  datasize += Tsizeof( Tsize_t );
  for ( Tsize_t i = 0; i < nchar; i ++ ) {
    if ( i == ( nchar - 1 ) ) {
      charbuf = '\0';
    } else {
      charbuf = theID[ i ];
    }
    *( (Tchar*)buffer ) = charbuf;
    ( (Tchar*)buffer ) ++;
    datasize += Tsizeof( Tchar );
  }

   
  // write number of entries
  *( (Tsize_t*)buffer ) = size();
  ( (Tsize_t*)buffer ) ++;
  datasize += Tsizeof( Tsize_t );

  for ( Tsize_t i = 0; i < size(); i ++ ) {
    Tint d = ( (*this)[ i ] ).Serialize( buffer );
    datasize += d;
    (Tbyte*)buffer += d;
  }

  return (Tint)datasize;
}

const TDataSegment& TDataSection::operator[]( Tint n ) const
{
  return *( begin() + n );
}

TDataSegment& TDataSection::operator[]( Tint n )
{
  return *( begin() + n );
}

const TDataSegment& TDataSection::operator[]( const Tstring& id ) const
{
  return (*this)[ FindDataSegment( id ) ];
}

TDataSegment& TDataSection::operator[]( const Tstring& id )
{
  return (*this)[ FindDataSegment( id ) ];
}
