// =====================================================================
/*!
//
//  \file TSoftwareAdcModule.hh
//  \brief This file contains the TSoftwareAdcModule class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TSoftwareAdcModule.hh,v 1.4 2003/11/03 08:35:13 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TSoftwareAdcModule.hh,v $
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TSOFTWAREADCMODULE_HH
#define __TSOFTWAREADCMODULE_HH

#include "Tglobals.h"
#include "TSoftwareModule.hh"
#include "TChannel.hh"
#include "TRandomEngine.hh"
#include "TRandomFlat.hh"
#include "TRandomGaussian.hh"

class TDataSegment;
class TDataElement;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TSoftwareAdcModule
// \brief This is the TSoftwareAdcModule class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TSoftwareAdcModule class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TSoftwareAdcModule
  : public TSoftwareModule
{
  protected:
    enum { tDataOverFlow = -1 };
    enum { tDefaultScale = 4096 };
    enum { tDefaultChannel = 16 };

  protected:
    Tint theScale;
    TintList theMean;
    TintList theSigma;
    TChannel theChannel;
    Trandom_t theRandomType;

  protected:
    static Tint theSeed;
    static TRandomEngine theRandomEngine;

  public:
    TSoftwareAdcModule( Tint nchannel = tDefaultChannel, Tint scale = tDefaultScale, Trandom_t randtype = tRandomGaussian );
    TSoftwareAdcModule( const TSoftwareAdcModule& right );
    virtual ~TSoftwareAdcModule();

  public:
    virtual Tint Clear();
    virtual Tint Update();
    virtual Tint Initialize();
    virtual Tvoid FillData( TDataElement& element, Tint channel );

  public:
    virtual const TSoftwareAdcModule& operator=( const TSoftwareAdcModule& right );
    virtual Tbool operator==( const TSoftwareAdcModule& right ) const;
    virtual Tbool operator!=( const TSoftwareAdcModule& right ) const;

  public:
    virtual Tint GetScale() const;
    virtual const TintList& GetMean() const;
    virtual Tint GetMean( Tint channel ) const;
    virtual const TintList& GetSigma() const;
    virtual Tint GetSigma( Tint channel ) const;
    virtual const TChannel& GetChannel() const;
    virtual Tint GetData( Tint channel ) const;
    virtual Trandom_t GetRandomType() const;
    virtual Tvoid SetScale( Tint scale );
    virtual Tvoid SetMean( const TintList& meanlist );
    virtual Tvoid SetMean( Tint channel, Tint mean );
    virtual Tvoid SetSigma( const TintList& sigmalist );
    virtual Tvoid SetSigma( Tint channel, Tint sigma );
    virtual Tvoid SetChannel( const TChannel& channels );
    virtual Tvoid SetData( Tint channel, Tint data );
    virtual Tvoid GetRandomType( Trandom_t randomtype );

  public:
    static Tint GetSeed();
    static const TRandomEngine& GetRandomEngine();
    static Tvoid SetSeed( Tint seed );
    static Tvoid SetRandomEngine( const TRandomEngine& engine );

  protected:
    virtual Tvoid setParameters();
    virtual Tvoid fillGaussian();

};

inline Tint TSoftwareAdcModule::GetScale() const
{
  return theScale;
}

inline const TintList& TSoftwareAdcModule::GetMean() const
{
  return theMean;
}

inline Tint TSoftwareAdcModule::GetMean( Tint channel ) const
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TSoftwareAdcModule::GetMean: invalid ID" << Tendl;
    return -EFAULT;
  } else {
    return theMean[ channel ];
  }
}

inline const TintList& TSoftwareAdcModule::GetSigma() const
{
  return theSigma;
}

inline Tint TSoftwareAdcModule::GetSigma( Tint channel ) const
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TSoftwareAdcModule::GetSigma: invalid ID" << Tendl;
    return -EFAULT;
  } else {
    return theSigma[ channel ];
  }
}

inline const TChannel& TSoftwareAdcModule::GetChannel() const
{
  return theChannel;
}

inline Tint TSoftwareAdcModule::GetData( Tint channel ) const
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TSoftwareAdcModule::GetData: invalid ID" << Tendl;
    return -EFAULT;
  } else {
    return theChannel[ channel ];
  }
}

inline Trandom_t TSoftwareAdcModule::GetRandomType() const
{
  return theRandomType;
}

inline Tvoid TSoftwareAdcModule::SetScale( Tint scale )
{
  theScale = scale;
  return;
}

inline Tvoid TSoftwareAdcModule::SetMean( const TintList& meanlist )
{
  theMean = meanlist;
  return;
}

inline Tvoid TSoftwareAdcModule::SetMean( Tint channel, Tint mean )
{
  if ( channel < 0 || channel >= theNumberOfChannels )
    Tcerr << "TSoftwareAdc::SetMean: invalid ID" << Tendl;
  else
    theMean[ channel ] = mean;
  return;
}

inline Tvoid TSoftwareAdcModule::SetSigma( const TintList& sigmalist )
{
  theSigma = sigmalist;
  return;
}

inline Tvoid TSoftwareAdcModule::SetSigma( Tint channel, Tint sigma )
{
  if ( channel < 0 || channel >= theNumberOfChannels )
    Tcerr << "TSoftwareAdc::SetSigma: invalid ID" << Tendl;
  else
    theSigma[ channel ] = sigma;
  return;
}

inline Tvoid TSoftwareAdcModule::SetChannel( const TChannel& channels )
{
  theChannel = channels;
  return;
}

inline Tvoid TSoftwareAdcModule::SetData( Tint channel, Tint data )
{
  if ( channel < 0 || channel >= theNumberOfChannels )
    Tcerr << "TSoftwareAdc::SetData: invalid ID" << Tendl;
  else
    theChannel[ channel ] = data;
  return;
}

inline Tvoid TSoftwareAdcModule::GetRandomType( Trandom_t randomtype )
{
  theRandomType = randomtype;
  return;
}

inline Tint TSoftwareAdcModule::GetSeed()
{
  return TSoftwareAdcModule::theSeed;
}

inline const TRandomEngine& TSoftwareAdcModule::GetRandomEngine()
{
  return TSoftwareAdcModule::theRandomEngine;
}

inline Tvoid TSoftwareAdcModule::SetSeed( Tint seed )
{
  TSoftwareAdcModule::theSeed = seed;
  return;
}

inline Tvoid TSoftwareAdcModule::SetRandomEngine( const TRandomEngine& engine )
{
  TSoftwareAdcModule::theRandomEngine = engine;
  return;
}

#endif
