// =====================================================================
//  $Id: TSoftwareRunInformationModule.cc,v 1.3 2003/10/06 17:02:40 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TSoftwareRunInformationModule.cc,v $
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformation.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

TSoftwareRunInformationModule::TSoftwareRunInformationModule()
  : TSoftwareModule( 0 ), theRunInformationTable()
{
  theRunInformationTable.Clear();
  theNumberOfChannels = theRunInformationTable.GetNumberOfRows();
}

TSoftwareRunInformationModule::TSoftwareRunInformationModule( const TRunInformationTable& table )
  : TSoftwareModule( 0 ), theRunInformationTable( table )
{
  theNumberOfChannels = theRunInformationTable.GetNumberOfRows();
}

TSoftwareRunInformationModule::TSoftwareRunInformationModule( const TSoftwareRunInformationModule& right )
  : TSoftwareModule( right ), theRunInformationTable( right.theRunInformationTable )
{
  theNumberOfChannels = theRunInformationTable.GetNumberOfRows();
}

TSoftwareRunInformationModule::~TSoftwareRunInformationModule()
{;}

Tvoid TSoftwareRunInformationModule::FillData( TDataElement& element, Tint channel )
{
  if ( channel < 0 || channel >= theNumberOfChannels ) {
    Tcerr << "TSoftwareRunInformationModule::FillData: invalid ID " << channel << Tendl;
    theStatus = -EFAULT;
    element.FillData( &theStatus, tTypeInt, 1 );
  } else {
    const TRunInformationList& list = theRunInformationTable.GetRunInformationList();
    Tstring item = list[ channel ].GetItem();
    Tstring value = list[ channel ].GetValue();
    element.FillData( &value, tTypeString, 1 );
    element.SetID( item );
  }
  return;
}

const TSoftwareRunInformationModule& TSoftwareRunInformationModule::operator=( const TSoftwareRunInformationModule& right )
{
  *( (TSoftwareModule*)this ) = *( (TSoftwareModule*)(&right) );
  theRunInformationTable = right.theRunInformationTable;
  return *this;
}

Tbool TSoftwareRunInformationModule::operator==( const TSoftwareRunInformationModule& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( *( (TSoftwareModule*)this ) == *( (TSoftwareModule*)(&right) ) );
  retval &= ( theRunInformationTable == right.theRunInformationTable );
  return retval;
}

Tbool TSoftwareRunInformationModule::operator!=( const TSoftwareRunInformationModule& right ) const
{
  Tbool retval = Tfalse;
  retval |= ( *( (TSoftwareModule*)this ) != *( (TSoftwareModule*)(&right) ) );
  retval |= ( theRunInformationTable != right.theRunInformationTable );
  return retval;
}

Tint TSoftwareRunInformationModule::Clear()
{
  //should be called Clear()?
  //for ( Tsize_t i = 0; i < theRunInformationTable.size(); i ++ ) {
  //theRunInformationTable[ i ].Clear();
  //}
  return theStatus = tStatusSuccess;
}

Tint TSoftwareRunInformationModule::Update()
{
  theNumberOfChannels = theRunInformationTable.GetNumberOfRows();
  return theStatus = tStatusSuccess;
}

Tint TSoftwareRunInformationModule::Initialize()
{
  //should be called Remove()?
  theRunInformationTable.Clear();
  theNumberOfChannels = theRunInformationTable.GetNumberOfRows();
  return theStatus = tStatusSuccess;  
}
