// =====================================================================
/*!
//
//  \file TInputObjectFile.hh
//  \brief This file contains the TInputObjectFile class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TInputObjectFile.hh,v 1.5 2003/11/03 08:35:13 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TInputObjectFile.hh,v $
//  Revision 1.5  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.4  2003/10/12 13:04:56  goiwai
//  եνüã뤫ɤߤߤ˼ԤȤˤ 0 ֤褦ˤ
//  ޤ.ե饤ǤϤǽʬǤ礦.
//  while ( stream -> Read( record ) ) {
//    ;
//  }
//
//  Revision 1.3  2003/10/06 17:02:42  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TINPUTOBJECTFILE_HH
#define __TINPUTOBJECTFILE_HH

#include "Tglobals.h"
#include "TObjectFile.hh"
#include "TInputObjectStream.hh"

class TStreamableObject;
class TDataRecord;
class TDataSection;
class TDataSegment;
class TDataElement;
class TObjectFilter;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TInputObjectFile
// \brief This is the TInputObjectFile class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TInputObjectFile class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup PersistencyCategory
*/
class TInputObjectFile
  : public TObjectFile, public TInputObjectStream
{

  public:
    TInputObjectFile( const Tstring& filename, const Tstring& mode = "r" );
    TInputObjectFile( TObjectFilter* filter, const Tstring& filename, const Tstring& mode = "r" );
    virtual ~TInputObjectFile();

  public:
    virtual Tint Read( TStreamableObject& object );

  protected:
    virtual TDataRecord getDataRecord();
    virtual TDataSection getDataSection();
    virtual TDataSegment getDataSegment();
    virtual TDataElement getDataElement();
    virtual Tvoid readProperties( Tint& recsize, Tobject_t& type, Tstring& id, Tsize_t& entries );

};

#endif
