// =====================================================================
/*!
//
//  \file TObjectStream.hh
//  \brief This file contains the TObjectStream class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TObjectStream.hh,v 1.4 2003/11/03 08:35:13 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TObjectStream.hh,v $
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:42  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TOBJECTSTREAM_HH
#define __TOBJECTSTREAM_HH

#include "Tglobals.h"

class TObjectFilter;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TObjectStream
// \brief This is the TObjectStream class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TObjectStream class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup PersistencyCategory
*/
class TObjectStream
{

  protected:
    TObjectFilter* theObjectFilter;
    Tstream_t theStreamType;
    Tint theDataSize;
    Tint theLastDataSize;
    Tint theTotalDataSize;

  public:
    TObjectStream( Tstream_t streamtype = tUnknownStream );
    TObjectStream( TObjectFilter* filter, Tstream_t streamtype = tUnknownStream );

  protected:
    virtual ~TObjectStream();

  public:
    Tstream_t GetStreamType() const;
    Tvoid SetStreamType( Tstream_t streamtype );
    TObjectFilter* GetObjectFilter() const;
    Tvoid SetObjectFilter( TObjectFilter* filter );
    Tbool HasFilter() const;
    Tint GetDataSize() const;
    Tint GetLastDataSize() const;
    Tvoid SetDataSize( Tint datasize );
    Tvoid SetLastDataSize( Tint datasize );
    Tint GetTotalDataSize() const;

};

inline Tint TObjectStream::GetDataSize() const
{
  return theDataSize;
}

inline Tint TObjectStream::GetLastDataSize() const
{
  return theLastDataSize;
}

inline Tvoid TObjectStream::SetDataSize( Tint datasize )
{
  theDataSize = datasize;
  return;
}

inline Tvoid TObjectStream::SetLastDataSize( Tint datasize )
{
  theLastDataSize = datasize;
  return;
}

inline Tstream_t TObjectStream::GetStreamType() const
{
  return theStreamType;
}

inline Tvoid TObjectStream::SetStreamType( Tstream_t streamtype )
{
  theStreamType = streamtype;
  return;
}

inline TObjectFilter* TObjectStream::GetObjectFilter() const
{
  return theObjectFilter;
}

inline Tvoid TObjectStream::SetObjectFilter( TObjectFilter* filter )
{
  theObjectFilter = filter;
  return;
}

inline Tbool TObjectStream::HasFilter() const
{
  return ( theObjectFilter != 0 ) ? Ttrue : Tfalse;
}

inline Tint TObjectStream::GetTotalDataSize() const
{
  return theTotalDataSize;
}

#endif
