// =====================================================================
//  $Id: TOutputObjectSocket.cc,v 1.3 2003/10/06 17:02:42 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TOutputObjectSocket.cc,v $
//  Revision 1.3  2003/10/06 17:02:42  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TOutputObjectSocket.hh"
#include "TStreamableObject.hh"
#include "TObjectFilter.hh"

TOutputObjectSocket::TOutputObjectSocket( const Tstring& hostname, Tint port )
  : TObjectSocket( port ), TOutputObjectStream( tSocketStream ), 
    theServerName( hostname ), theHostInformation( 0 )
{
  initialize();
}

TOutputObjectSocket::TOutputObjectSocket( Tint port )
  : TObjectSocket( port ), TOutputObjectStream( tSocketStream ), 
    theServerName( "localhost" ), theHostInformation( 0 )
{
  initialize();
}

TOutputObjectSocket::TOutputObjectSocket( TObjectFilter* filter, const Tstring& hostname, Tint port )
  : TObjectSocket( port ), TOutputObjectStream( filter, tSocketStream ), 
    theServerName( hostname ), theHostInformation( 0 )
{
  initialize();
}

TOutputObjectSocket::TOutputObjectSocket( TObjectFilter* filter, Tint port )
  : TObjectSocket( port ), TOutputObjectStream( filter, tSocketStream ), 
    theServerName( "localhost" ), theHostInformation( 0 )
{
  initialize();
}

TOutputObjectSocket::~TOutputObjectSocket()
{
  CloseServer();
}

Tvoid TOutputObjectSocket::initialize()
{
  theHostInformation = gethostbyname( theServerName.c_str() );
  if ( theHostInformation == 0 ) {
    perror( "TOutputObjectSocket::initialize" );
    exit( -errno );
  }
  theAddress.sin_family = PF_INET;
  theAddress.sin_port = htons( (TUshort)thePortNumber );
  theAddress.sin_addr.s_addr =
    *( (unsigned long *)( *( theHostInformation -> h_addr_list ) ) );

  OpenServer();
  Tsocklen_t len = (Tsocklen_t)( Tsizeof( theAddress ) );

  if ( connect( theServerDescriptor, (struct sockaddr *)&theAddress, len ) == -1 )
    perror( "TOutputObjectSocket::initialize" );


  return;
}

Tint TOutputObjectSocket::Write( TStreamableObject& object )
{
  theLastDataSize = theDataSize;
  theDataSize = 0;

  if ( HasFilter() ) {
    theDataSize = theObjectFilter -> Filtering( object, this );
  } else {
    theDataSize = object.Record( this );
  }

  theTotalDataSize += theDataSize;
  return theDataSize;
}
