// =====================================================================
/*!
//
//  \file TOutputObjectSocket.hh
//  \brief This file contains the TOutputObjectSocket class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TOutputObjectSocket.hh,v 1.4 2003/11/03 08:35:13 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TOutputObjectSocket.hh,v $
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:42  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TOUTPUTOBJECTSOCKET_HH
#define __TOUTPUTOBJECTSOCKET_HH

#include "Tglobals.h"
#include "TObjectSocket.hh"
#include "TOutputObjectStream.hh"

class TStreamableObject;
class TObjectFilter;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TOutputObjectSocket
// \brief This is the TOutputObjectSocket class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TOutputObjectSocket class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup PersistencyCategory
*/
class TOutputObjectSocket
  : public TObjectSocket, public TOutputObjectStream
{

  private:
    Tstring theServerName;
    struct hostent* theHostInformation;

  public:
    TOutputObjectSocket( const Tstring& hostname = "localhost", Tint port = tDefaultPortNumber );
    TOutputObjectSocket( Tint port );
    TOutputObjectSocket( TObjectFilter* filter, const Tstring& hostname = "localhost", Tint port = tDefaultPortNumber );
    TOutputObjectSocket( TObjectFilter* filter, Tint port );
    ~TOutputObjectSocket();

  public:
    Tint Write( TStreamableObject& object );

  public:
    const Tstring& GetServerName() const;

  private:
    Tvoid initialize();

};

inline const Tstring& TOutputObjectSocket::GetServerName() const
{
  return theServerName;
}

#endif
