// =====================================================================
/*!
//
//  \file TOutputObjectStream.hh
//  \brief This file contains the TOutputObjectStream class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TOutputObjectStream.hh,v 1.4 2003/11/03 08:35:13 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TOutputObjectStream.hh,v $
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:42  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TOUTPUTOBJECTSTREAM_HH
#define __TOUTPUTOBJECTSTREAM_HH

#include "Tglobals.h"
#include "TObjectStream.hh"

class TStreamableObject;
class TObjectFilter;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TOutputObjectStream
// \brief This is the TOutputObjectStream class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TOutputObjectStream class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup PersistencyCategory
*/
class TOutputObjectStream
  : public TObjectStream
{

  public:
    TOutputObjectStream( Tstream_t streamtype = tUnknownStream );
    TOutputObjectStream( TObjectFilter* filter, Tstream_t streamtype = tUnknownStream );

  protected:
    virtual ~TOutputObjectStream();

  public:
    virtual Tint Write( TStreamableObject& object ) = 0;
    friend Tint operator<<( TOutputObjectStream& left, TStreamableObject& object );
    friend Tint operator<<( TOutputObjectStream& left, const TStreamableObject& object );

};

inline Tint operator<<( TOutputObjectStream& left, TStreamableObject& object )
{
  return left.Write( object );
}

inline Tint operator<<( TOutputObjectStream& left, const TStreamableObject& object )
{
  return left.Write( *(TStreamableObject*)(&object) );
}

#endif
