// =====================================================================
/*!
//
//  \file TDataInflation.hh
//  \brief This file contains the TDataInflation class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TDataInflation.hh,v 1.4 2003/11/03 08:35:15 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TDataInflation.hh,v $
//  Revision 1.4  2003/11/03 08:35:15  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 16:37:49  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:21:20  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TDATAINFLATION_HH
#define __TDATAINFLATION_HH
#ifdef __CLDAQ_ZLIB_USE

#include "Tglobals.h"


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TDataInflation
// \brief This is the TDataInflation class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TDataInflation class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup SystemCategory
*/
class TDataInflation
{

  private:
    enum { tDefaultBufferSize = 1024 * 1024 };

  private:
    Tzstream theInflationStream;
    Tint theStatus;
    Tbyte* theOutputBuffer;
    Tint theSizeOfOutputBuffer;
    Tvoid* theInflatedData;
    Tint theSizeOfInflatedData;

  public:
    TDataInflation( Tint bufsize = tDefaultBufferSize );
    TDataInflation( const TDataInflation& right );
    ~TDataInflation();

  public:
    const TDataInflation& operator=( const TDataInflation& right );

  public:
    Tvoid Decompress( Tvoid* input, Tint nbyte );

  public:
    const Tzstream& GetInflationStream() const;
    Tzstream& GetInflationStream();
    Tint GetStatus() const;
    Tint GetSizeOfOutputBuffer() const;
    Tvoid* GetInflatedData() const;
    Tint GetSizeOfInflatedData() const;
    Tvoid SetOutputBuffer( Tint bufsize );

};

inline const Tzstream& TDataInflation::GetInflationStream() const
{
  return theInflationStream;
}

inline Tzstream& TDataInflation::GetInflationStream()
{
  return theInflationStream;
}

inline Tint TDataInflation::GetStatus() const
{
  return theStatus;
}

inline Tint TDataInflation::GetSizeOfOutputBuffer() const
{
  return theSizeOfOutputBuffer;
}

inline Tvoid* TDataInflation::GetInflatedData() const
{
  return theInflatedData;
}

inline Tint TDataInflation::GetSizeOfInflatedData() const
{
  return theSizeOfInflatedData;
}

#endif
#endif
