// =====================================================================
/*!
//
//  \file TSignalHandler.hh
//  \brief This file contains the TSignalHandler class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TSignalHandler.hh,v 1.4 2003/11/03 08:35:15 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TSignalHandler.hh,v $
//  Revision 1.4  2003/11/03 08:35:15  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 16:37:49  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:21:21  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef __TSIGNALHANDLER_HH
#define __TSIGNALHANDLER_HH

#include "Tglobals.h"

class TSignalClient;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TSignalHandler
// \brief This is the TSignalHandler class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TSignalHandler class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup SystemCategory
*/
class TSignalHandler
{

  public:
    enum { MAX_SIGNAL_ENTRY = 32 };

  protected:
    static TSignalHandler* handler_list[ MAX_SIGNAL_ENTRY ];

  protected:
    Tint signal_id;
    TSignalClient* client;

  protected:
    Tvoid signal_ucr( Tint sig );

  public:
    TSignalHandler( Tint psignalid, TSignalClient* pclient );

  public:
    Tvoid Enable();
    Tvoid Disable();
    Tint Wait();

  public:
    static Tvoid Initialize();

  protected:
    static Tvoid signal_handler( Tint, Tint, struct sigcontext* , Tchar* );

};

#endif
