// ============================================================================
/*!
//
//  \file TUtilities.hh
//  \brief This file contains the TUtilities class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TUtilities.hh,v 1.2 2003/11/03 08:35:15 goiwai Exp $
//  $Name: CLDAQ-1-10-00 $
//  $Log: TUtilities.hh,v $
//  Revision 1.2  2003/11/03 08:35:15  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.1  2003/10/06 16:34:36  goiwai
//  ǡѴɽ,ˤ˻ѤؿΤΥåѡ饹
//  Ǥ.CΥ饤֥ؿǡѤǤޤ.
//
*/
// ============================================================================
#ifndef __TUTILITIES_HH
#define __TUTILITIES_HH

#include "Ttypes.h"


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TUtilities
// \brief This is the TUtilities class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TUtilities class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup SystemCategory
*/
class TUtilities
{

  public:
    static Tstring ConvertIntegerToString( Tint i, Tint digits );
    static Tstring ConvertLongToString( Tlong l, Tint digits );
    static Tstring ConvertUnsignedLongToString( TUlong ul, Tint digits );
    static Tstring ConvertDoubleToString( Tdouble d, Tint precision );
    static Tstring ConvertFloatToString( Tfloat f, Tint precision );
    static Tint ConvertStringToInteger( const Tstring& nptr, Tchar** endptr, Tint base );
    static Tdouble ConvertStringToDouble( const Tstring& nptr, Tchar** endptr );
    static Tvoid ShowBitPattern( Tint bit );
    static Tbool FileExist( const Tstring& filename );
    static TstringList Split( const Tstring& source, const Tstring& pattern, Tint pos );
    static TintList Indexes( const Tstring& source, const Tstring& pattern, Tint pos );
    static TintList Sizes( const Tstring& source, const Tstring& pattern, Tint pos );
    static Tstring Substitute( const Tstring& source, const Tstring& pattern, const Tstring& substr, Tint pos );
    static Tstring SubstituteAll( const Tstring& source, const Tstring& pattern, const Tstring& substr, Tint pos );
    static Tbool IsMatch( const Tstring& source, const Tstring& pattern, Tbool igcase, Tint pos );
    static Tstring GetBaseName( const Tstring& path );
    static Tstring GetDirectoryName( const Tstring& path );

  public:
    friend Tstring itostr( Tint i, Tint digits = 6 );
    friend Tstring ltostr( Tlong l, Tint digits = 6 );
    friend Tstring ultostr( TUlong ul, Tint digits = 6 );
    friend Tstring dtostr( Tdouble d, Tint precision = 6 );
    friend Tstring ftostr( Tfloat f, Tint precision = 6 );
    friend Tint strtoi( const Tstring& nptr, Tchar** endptr = 0, Tint base = 0 );
    friend Tdouble strtod( const Tstring& nptr, Tchar** endptr = 0 );
    friend Tvoid showbit( Tint bit );
    friend Tbool isexist( const Tstring& filename );
    friend TstringList split( const Tstring& source, const Tstring& pattern = "[\t+| +]", Tint pos = 0 );
    friend TintList index( const Tstring& source, const Tstring& pattern, Tint pos = 0 );
    friend TintList size( const Tstring& source, const Tstring& pattern, Tint pos = 0 );
    friend Tstring subst( const Tstring& source, const Tstring& pattern, Tstring& substr, Tbool all = Ttrue, Tint pos = 0 );
    friend Tbool grep( const Tstring& source, const Tstring& pattern, Tbool igcase = Tfalse, Tint pos = 0 );
    friend Tstring basename( const Tstring& path );
    friend Tstring dirname( const Tstring& path );
 
};

inline Tstring itostr( Tint i, Tint digits )
{
  return TUtilities::ConvertIntegerToString( i, digits );
}

inline Tstring ltostr( Tlong l, Tint digits )
{
  return TUtilities::ConvertLongToString( l, digits );
}

inline Tstring ultostr( TUlong ul, Tint digits )
{
  return TUtilities::ConvertUnsignedLongToString( ul, digits );
}

inline Tstring dtostr( Tdouble d, Tint precision )
{
  return TUtilities::ConvertDoubleToString( d, precision );
}

inline Tstring ftostr( Tfloat f, Tint precision )
{
  return TUtilities::ConvertFloatToString( f, precision );
}

inline Tint strtoi( const Tstring& nptr, Tchar** endptr, Tint base )
{
  return TUtilities::ConvertStringToInteger( nptr, endptr, base );
}

inline Tdouble strtod( const Tstring& nptr, Tchar** endptr )
{
  return TUtilities::ConvertStringToDouble( nptr, endptr );
}

inline Tvoid showbit( Tint bit )
{
  TUtilities::ShowBitPattern( bit );
  return;
}

inline Tbool isexist( const Tstring& filename )
{
  return TUtilities::FileExist( filename );
}

inline TstringList split( const Tstring& source, const Tstring& pattern, Tint pos )
{
  return TUtilities::Split( source, pattern, pos );
}

inline TintList index( const Tstring& source, const Tstring& pattern, Tint pos )
{
  return TUtilities::Indexes( source, pattern, pos );
}

inline TintList size( const Tstring& source, const Tstring& pattern, Tint pos )
{
  return TUtilities::Sizes( source, pattern, pos );
}

inline Tstring subst( const Tstring& source, const Tstring& pattern, const Tstring& substr, Tbool all, Tint pos )
{
  if ( all ) {
    return TUtilities::SubstituteAll( source, pattern, substr, pos );
  } else {
    return TUtilities::Substitute( source, pattern, substr, pos );
  }
}

inline Tbool grep( const Tstring& source, const Tstring& pattern, Tbool igcase, Tint pos )
{
  return TUtilities::IsMatch( source, pattern, igcase, pos );
}

inline Tstring basename( const Tstring& path )
{
  return TUtilities::GetBaseName( path );
}

inline Tstring dirname( const Tstring& path )
{
  return TUtilities::GetDirectoryName( path );
}

#endif
