// ============================================================================
//  $Id: BtDummyEventAction.cc,v 1.1 2002/12/07 13:14:40 iwai Exp $
//  $Name:  $
// ============================================================================
#include "BtDummyEventAction.hh"
#include "BtDummyRunAction.hh"
#include "BtDummyModuleManager.hh"
#include "TRunManager.hh"
#include "TOutputObjectFile.hh"

BtDummyEventAction::BtDummyEventAction( BtDummyModuleManager* manager )
  : theModuleManager( manager )
{;}

BtDummyEventAction::~BtDummyEventAction()
{;}

Tvoid BtDummyEventAction::BeginOfEventAction( TEvent& anEvent )
{
  //begin -> (update) -> wait -> read -> end
  return;
}

const TReadoutList& BtDummyEventAction::WaitEvent()
{
  // random trigger with nanosleep
  struct timespec req;
  Tlong rnd = lrand48();
  req.tv_sec = 0;
  req.tv_nsec = rnd;
  nanosleep( &req, 0 );

  if ( rnd % 5 == 0 ) {
    // record as scaler event.
    return( *( theModuleManager -> GetScalerEventReadoutList() ) );
  }
  
  return( *( theModuleManager -> GetEventReadoutList() ) );
}

Tvoid BtDummyEventAction::EndOfEventAction( TEvent& anEvent )
{
  BtDummyRunAction* action =
    (BtDummyRunAction*)( TRunManager::GetRunManager() -> GetRunAction() );
  TOutputObjectFile* ofile = action -> GetOutputFile();

  TDataRecord record = anEvent.GetDataRecord();
  ofile -> WriteData( record );

  theModuleManager -> Update();

  return;
}
