// ============================================================================
//  $Id: BtModuleManager.hh,v 1.4 2002/12/08 23:28:14 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __BTMODULEMANAGER_HH
#define __BTMODULEMANAGER_HH

#include "Tglobals.h"
#include "TSoftwareScalerModule.hh"

class TCamacCrateController;
class TCamacAdcModule;
class TCamacScalerModule;
class TCamacOutputRegisterModule;
class TCamacCoincidenceRegisterModule;
class TCamacInterruptRegisterModule;
class TSoftwareRunInformationModule;
class TSoftwareScalerModule;
class TSoftwareTimerModule;
class TSoftwareClockModule;
class TReadoutList;

class BtModuleManager
{

  private:
    static BtModuleManager* theModuleManager;

  private:
    TCamacCrateController* theCrateController;
    TCamacAdcModule* theAdc;
    TCamacScalerModule* theScaler;
    TCamacOutputRegisterModule* theOutput;
    TCamacCoincidenceRegisterModule* theCoincidence;
    TCamacInterruptRegisterModule* theInterrupt;    
    TSoftwareRunInformationModule* theRunInfo;
    TSoftwareTimerModule* theTimer;
    TSoftwareClockModule* theClock;
    TSoftwareScalerModule* theRunNumber;
    TSoftwareScalerModule* theEventNumber;
    TReadoutList* theRunBeginReadoutList;
    TReadoutList* theRunEndReadoutList;
    TReadoutList* theEventReadoutList;
    TReadoutList* theScalerEventReadoutList;

  public:
    BtModuleManager();
    ~BtModuleManager();

  public:
    static BtModuleManager* GetModuleManager();

  public:
    const TCamacCrateController* GetCrateController() const;
    const TCamacAdcModule* GetAdc() const;
    const TCamacScalerModule* GetScaler() const;
    TCamacOutputRegisterModule* GetOutput() const;
    const TCamacCoincidenceRegisterModule* GetCoincidence() const;
    TCamacInterruptRegisterModule* GetInterrupt() const;
    const TSoftwareTimerModule* GetTimer() const;
    const TSoftwareClockModule* GetClock() const;
    TSoftwareRunInformationModule* GetRunInfo() const;
    TSoftwareScalerModule* GetRunNumber() const;
    const TSoftwareScalerModule* GetEventNumber() const;
    TReadoutList* GetRunBeginReadoutList() const;
    TReadoutList* GetRunEndReadoutList() const;
    const TReadoutList* GetEventReadoutList() const;
    const TReadoutList* GetScalerEventReadoutList() const;

  public:
    Tvoid Update( const Tstring& updateid );
    Tvoid SetRunNumber( Tint runid ) const;
    Tvoid Initialize();

  private:
    Tvoid defineModule();
    Tvoid defineReadoutList();
    
};

inline BtModuleManager* BtModuleManager::GetModuleManager()
{
  return( theModuleManager );
}

inline const TCamacCrateController* BtModuleManager::GetCrateController() const
{
  return( theCrateController );
}

inline const TCamacAdcModule* BtModuleManager::GetAdc() const
{
  return( theAdc );
}

inline const TCamacScalerModule* BtModuleManager::GetScaler() const
{
  return( theScaler );
}

inline TCamacOutputRegisterModule* BtModuleManager::GetOutput() const
{
  return( theOutput );
}

inline const TCamacCoincidenceRegisterModule* BtModuleManager::GetCoincidence() const
{
  return( theCoincidence );
}

inline TCamacInterruptRegisterModule* BtModuleManager::GetInterrupt() const
{
  return( theInterrupt );
}

inline TSoftwareRunInformationModule* BtModuleManager::GetRunInfo() const
{
  return( theRunInfo );
}

inline const TSoftwareTimerModule* BtModuleManager::GetTimer() const
{
  return( theTimer );
}

inline const TSoftwareClockModule* BtModuleManager::GetClock() const
{
  return( theClock );
}

inline TReadoutList* BtModuleManager::GetRunBeginReadoutList() const
{
  return( theRunBeginReadoutList );
}

inline TReadoutList* BtModuleManager::GetRunEndReadoutList() const
{
  return( theRunEndReadoutList );
}

inline const TReadoutList* BtModuleManager::GetEventReadoutList() const
{
  return( theEventReadoutList );
}

inline const TReadoutList* BtModuleManager::GetScalerEventReadoutList() const
{
  return( theScalerEventReadoutList );
}

inline TSoftwareScalerModule* BtModuleManager::GetRunNumber() const
{
  return( theRunNumber );
}

inline const TSoftwareScalerModule* BtModuleManager::GetEventNumber() const
{
  return( theEventNumber );
}

inline Tvoid BtModuleManager::SetRunNumber( Tint runid ) const
{
  theRunNumber -> SetData( 0, runid );
  return;
}

#endif
