// ============================================================================
//  $Id: AsoReadoutList.hh,v 1.1.1.1 2002/12/04 23:47:38 iwai Exp $
//  $Name:  $
// ============================================================================
#ifndef __ASOREADOUTLIST_HH
#define __ASOREADOUTLIST_HH

#include "Tglobals.h"
#include "TReadoutList.hh"
#include "TDataRecord.hh"
#include "TSoftwareScalerModule.hh"
#include "TSoftwareClockModule.hh"
#include "TVmeMpx201aModule.hh"

class TReadoutList;
class TDataRecord;
class TSoftwareScalerModule;
class TSoftwareClockModule;
class TVmeMpx201aModule;

class AsoReadoutList
{

  private:
    TReadoutList theReadoutList;
    TSoftwareScalerModule* theScaler;
    TSoftwareClockModule* theClock;
    TVmeMpx201aModule* theFadc;

  public:
    AsoReadoutList();
    ~AsoReadoutList();

  public:
    TDataRecord ReadData();
    const TReadoutList& GetReadoutList() const;
    TSoftwareScalerModule* GetScaler() const;
    TSoftwareClockModule* GetClock() const;
    TVmeMpx201aModule* GetFadc() const;

};

inline TDataRecord AsoReadoutList::ReadData()
{
  return( theReadoutList.ReadData() );
}

inline const TReadoutList& AsoReadoutList::GetReadoutList() const
{
  return( theReadoutList );
}

inline TSoftwareScalerModule* AsoReadoutList::GetScaler() const
{
  return( theScaler );
}

inline TSoftwareClockModule* AsoReadoutList::GetClock() const
{
  return( theClock );
}

inline TVmeMpx201aModule* AsoReadoutList::GetFadc() const
{
  return( theFadc );
}

#endif
