// ============================================================================
//  $Id: asoanalysis02.cc,v 1.1.1.1 2002/12/04 23:47:39 iwai Exp $
//  $Name:  $
// ============================================================================
#include "Tglobals.h"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"


int main( int argc, char** argv, char** envv )
{
  if ( argc != 3 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>";
    Tcerr << Tspace << "<event No.>" << Tendl;;
    return( -1 );
  }
  const Tstring filename = argv[ 1 ];
  const Tint evtID = atoi( argv[ 2 ] );


  const Tint findsegID = 1210;  // CCD segment
  TInputObjectFile* ifile = new TInputObjectFile( filename );

  Tint nevents = 0;


  //$B$[$s$H$O(BSEEK$B5!G=$H$+$b$"$k$1$I$3$3$O%m!<%F%/$K(B
  TDataRecord record;
  while ( ( ifile -> ReadData( record ) ) != 0 ) {
    nevents ++;
    if ( nevents == evtID ) {


      for ( Tsize_t i = 0; i < record.size(); i ++ ) {
	TDataSection section = record[ i ];
	for ( Tsize_t j = 0; j < section.size(); j ++ ) {
	  TDataSegment segment = section[ j ];
	  if ( segment.GetID() == findsegID ) {
	    for ( Tsize_t k = 0; k < segment.size(); k ++ ) {
	      TDataElement element = segment[ k ];
	      Tint narray = element.GetNumberOfPrimitives();
	      //element.GetElementType()
	      TUshort* data = (TUshort*)( element.GetData() );

	      TUshort databuf;
	      for ( Tint n = 0; n < narray; n ++ ) {
		databuf = *data;
		Tint sign = databuf & 0x8000;
		sign = sign >> 15;
		if ( sign == 1 ) { // negative value
  		databuf &= 0x7fff;
  		databuf = databuf >> 4;
		} else if ( sign == 0 ) { // positive value
		  databuf = databuf >> 4;
		  databuf += 0x07ff;
		} else {
		  Tcerr << "failed.." << Tendl;
		}
		Tcout << n << " " << databuf << Tendl;
		data ++;
	      }
	    }
	  }
	}
      }
      break;
    }
  }



  delete ifile;
  return( 0 );
}
