/* MushConsole.hh */
/* Created by Enomoto Sanshiro on 29 November 2000. */
/* Last updated by Enomoto Sanshiro on 29 November 2000. */


#ifndef __MushConsole_hh__
#define __MushConsole_hh__


#include <string>
#include "MushDefs.hh"


class TMushConsole {
  public:
    TMushConsole(void);
    virtual ~TMushConsole();
    virtual void SetPrompt(const char* Prompt);
    virtual bool GetLine(std::string& Line);
    virtual bool GetLineTo(char* Buffer, size_t MaxSize);
  protected:
    char* _Prompt;
};


class TMushReadlineConsole: public TMushConsole {
  public:
    TMushReadlineConsole(void);
    virtual ~TMushReadlineConsole();
    virtual bool GetLine(std::string& Line);
    virtual bool GetLineTo(char* Buffer, size_t MaxSize);
};


#endif
